/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackSpeedResponse
extends BidibMessage {
    public static final Integer TYPE = 166;

    FeedbackSpeedResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 4) {
            throw new ProtocolException("No valid MSG_BM_SPEED received.");
        }
    }

    public FeedbackSpeedResponse(byte[] addr, int num, int decoderAddress, int speed) throws ProtocolException {
        this(addr, num, (int)TYPE, ByteUtils.concat(AddressData.toByteArray(new AddressData(decoderAddress, AddressTypeEnum.LOCOMOTIVE_FORWARD)), ByteUtils.toWORD(speed)));
    }

    public FeedbackSpeedResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 4) {
            throw new ProtocolException("No valid MSG_BM_SPEED received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_SPEED";
    }

    public AddressData getAddress() {
        byte[] data = this.getData();
        return new AddressData(ByteUtils.getWord(data[0], data[1]), AddressTypeEnum.valueOf((byte)((data[1] & 0xC0) >> 6)));
    }

    public int getSpeed() {
        byte[] data = this.getData();
        return ByteUtils.getWord(data[2], data[3]);
    }
}

