/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DecoderIdAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackXPomResponse
extends BidibMessage {
    public static final Integer TYPE = 168;

    FeedbackXPomResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 10) {
            throw new ProtocolException("No valid MSG_BM_XPOM received.");
        }
    }

    public FeedbackXPomResponse(byte[] addr, int num, AddressData decoderAddress, int vendorId, CommandStationPom opCode, int cvNumber, byte[] data) throws ProtocolException {
        this(addr, num, 168, FeedbackXPomResponse.prepareData(decoderAddress, vendorId, opCode, cvNumber, data));
    }

    public FeedbackXPomResponse(byte[] addr, int num, DecoderIdAddressData addressDID, CommandStationPom opCode, int cvNumber, byte[] data) throws ProtocolException {
        this(addr, num, 168, FeedbackXPomResponse.prepareData(addressDID, opCode, cvNumber, data));
    }

    public FeedbackXPomResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 10) {
            throw new ProtocolException("No valid MSG_BM_XPOM received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_XPOM";
    }

    private static byte[] prepareData(DecoderIdAddressData addressDID, CommandStationPom opCode, int cvNumber, byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        addressDID.writeToStream(out);
        byte opCodeValue = opCode.getType();
        out.write(opCodeValue);
        out.write(ByteUtils.getLowByte(cvNumber - 1));
        out.write(ByteUtils.getHighByte(cvNumber - 1));
        if ((opCodeValue & 0x80) == 128) {
            byte xCV = (byte)(cvNumber >> 16 & 0xFF);
            out.write(xCV);
        } else {
            out.write(0);
        }
        switch (opCode) {
            case RD_BLOCK: {
                break;
            }
            case RD_BYTE: 
            case WR_BIT: 
            case WR_BYTE: {
                out.write(data, 0, 1);
                break;
            }
            case XWR_BYTE1: {
                out.write(data, 0, 1);
                break;
            }
            case XWR_BYTE2: {
                out.write(data, 0, 2);
                break;
            }
            case X_RD_BLOCK: {
                break;
            }
            case X_WR_BIT: 
            case X_WR_BYTE1: {
                out.write(data, 0, 1);
                break;
            }
            case X_WR_BYTE2: {
                out.write(data, 0, 2);
                break;
            }
            case X_WR_BYTE3: {
                out.write(data, 0, 3);
                break;
            }
            case X_WR_BYTE4: {
                out.write(data, 0, 4);
                break;
            }
        }
        return out.toByteArray();
    }

    private static byte[] prepareData(AddressData decoderAddress, int vendorId, CommandStationPom opCode, int cvNumber, byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        decoderAddress.writeToStream(out);
        out.write(ByteUtils.getLowByte(vendorId));
        byte opCodeValue = opCode.getType();
        out.write(opCodeValue);
        out.write(ByteUtils.getLowByte(cvNumber - 1));
        out.write(ByteUtils.getHighByte(cvNumber - 1));
        if ((opCodeValue & 0x80) == 128) {
            byte xCV = (byte)(cvNumber >> 16 & 0xFF);
            out.write(xCV);
        } else {
            out.write(0);
        }
        switch (opCode) {
            case RD_BLOCK: {
                break;
            }
            case RD_BYTE: 
            case WR_BIT: 
            case WR_BYTE: {
                out.write(data, 0, 1);
                break;
            }
            case XWR_BYTE1: {
                out.write(data, 0, 1);
                break;
            }
            case XWR_BYTE2: {
                out.write(data, 0, 2);
                break;
            }
            case X_RD_BLOCK: {
                break;
            }
            case X_WR_BIT: 
            case X_WR_BYTE1: {
                out.write(data, 0, 1);
                break;
            }
            case X_WR_BYTE2: {
                out.write(data, 0, 2);
                break;
            }
            case X_WR_BYTE3: {
                out.write(data, 0, 3);
                break;
            }
            case X_WR_BYTE4: {
                out.write(data, 0, 4);
                break;
            }
        }
        return out.toByteArray();
    }

    public boolean isDiDAddress() {
        return this.getData()[4] != 0;
    }

    public DecoderIdAddressData getDID() {
        byte[] data = ByteUtils.subArray(this.getData(), 0, 5);
        DecoderIdAddressData did = new DecoderIdAddressData(data);
        return did;
    }

    public AddressData getDecoderAddress() {
        if (this.getDecoderVendorId() > 0) {
            return null;
        }
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        AddressData addressData = new AddressData(address, AddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
        return addressData;
    }

    public int getDecoderVendorId() {
        return ByteUtils.getInt(this.getData()[4]);
    }

    public int getDecoderSerialNum() {
        return ByteUtils.convertSerial(this.getData(), 0);
    }

    public int getAddressX() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[2], data[3]);
    }

    public int getMid() {
        int opCode = ByteUtils.getInt(this.getData()[4]);
        return opCode;
    }

    public int getOpCode() {
        int opCode = ByteUtils.getInt(this.getData()[5]);
        return opCode;
    }

    public int getCvNumber() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[6], data[7]) + 1;
    }

    public int getCvNumberX() {
        byte[] data = this.getData();
        return ByteUtils.getCvXNumber(data, 6) + 1;
    }

    public int getCvValue() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[9]);
    }

    public int[] getCvXValue() {
        byte[] data = this.getData();
        int[] result = null;
        switch (this.getOpCode()) {
            case 135: {
                result = new int[]{ByteUtils.getInt(data[9]), ByteUtils.getInt(data[10])};
                break;
            }
            case 139: {
                result = new int[]{ByteUtils.getInt(data[9]), ByteUtils.getInt(data[10]), ByteUtils.getInt(data[11])};
                break;
            }
            case 143: {
                result = new int[]{ByteUtils.getInt(data[9]), ByteUtils.getInt(data[10]), ByteUtils.getInt(data[11]), ByteUtils.getInt(data[12])};
                break;
            }
            case 129: {
                result = new int[]{ByteUtils.getInt(data[9]), ByteUtils.getInt(data[10]), ByteUtils.getInt(data[11]), ByteUtils.getInt(data[12])};
                break;
            }
            default: {
                result = new int[]{ByteUtils.getInt(data[9])};
            }
        }
        return result;
    }
}

