/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AbstractBidibGuestMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class GuestRequestUnsubscribeMessage
extends AbstractBidibGuestMessage {
    private int subscription;

    public GuestRequestUnsubscribeMessage(TargetModeEnum targetMode, int subscription) throws ProtocolException {
        this(targetMode, null, subscription);
    }

    public GuestRequestUnsubscribeMessage(TargetModeEnum targetMode, byte[] targetModeUniqueId, int subscription) throws ProtocolException {
        super(null, 0, targetMode, targetModeUniqueId, 209, () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(targetMode.getType());
            GuestRequestUnsubscribeMessage.appendTargetModeUniqueId(baos, targetModeUniqueId);
            baos.write(ByteUtils.getLowByte(subscription));
            baos.write(ByteUtils.getHighByte(subscription));
            return baos.toByteArray();
        });
        this.subscription = subscription;
    }

    public GuestRequestUnsubscribeMessage(byte[] message) throws ProtocolException {
        super(message);
        int index = this.indexHolder[0];
        this.subscription = ByteUtils.getInt(this.getData()[index++], this.getData()[index++]);
    }

    @Override
    public String getName() {
        return "MSG_GUEST_REQ_UNSUBSCRIBE";
    }

    public int getSubscription() {
        return this.subscription;
    }

    public int getSubscriptionUpstream() {
        return ByteUtils.getHighByte(this.subscription) & 0xFF;
    }

    public int getSubscriptionDownstream() {
        return ByteUtils.getLowByte(this.subscription) & 0xFF;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{80, 81};
    }
}

