/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AbstractBidibGuestMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class GuestResponseNotifyMessage
extends AbstractBidibGuestMessage {
    private int subMessageNum;
    private int subMessageType;
    private int contentStartIndex;

    public GuestResponseNotifyMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] uniqueId, int subscribedMessageNumber, byte ... wrappedContent) throws ProtocolException {
        super(addr, num, targetMode, uniqueId, 83, () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(targetMode.getType());
            GuestResponseNotifyMessage.appendTargetModeUniqueId(baos, uniqueId);
            baos.write(subscribedMessageNumber);
            if (wrappedContent != null && wrappedContent.length > 0) {
                try {
                    baos.write(wrappedContent);
                }
                catch (IOException ex) {
                    throw new ProtocolException("Add wrapped content to message data failed.");
                }
            }
            return baos.toByteArray();
        });
        this.subMessageNum = subscribedMessageNumber;
        if (wrappedContent != null && wrappedContent.length > 0) {
            this.subMessageType = ByteUtils.getInt(wrappedContent[0]);
        }
        this.contentStartIndex = 7;
    }

    public GuestResponseNotifyMessage(byte[] message) throws ProtocolException {
        super(message);
        int index = this.indexHolder[0];
        this.subMessageNum = ByteUtils.getInt(this.getData()[index++]);
        this.subMessageType = ByteUtils.getInt(this.getData()[index++]);
        this.contentStartIndex = index;
    }

    @Override
    protected byte[] extractTargetModeUniqueId() throws ProtocolException {
        return ByteUtils.subArray(this.getData(), 1, 5);
    }

    @Override
    public String getName() {
        return "MSG_GUEST_RESP_NOTIFY";
    }

    public int getSubMessageNum() {
        return this.subMessageNum;
    }

    public int getSubMessageType() {
        return this.subMessageType;
    }

    public byte[] getWrappedContent() throws ProtocolException {
        int index = 0;
        byte[] data = null;
        if (this.contentStartIndex < this.getData().length) {
            data = ByteUtils.subArray(this.getData(), this.contentStartIndex);
        }
        byte[] content = new byte[2 + (data != null ? data.length : 0)];
        content[index++] = ByteUtils.getLowByte(this.subMessageNum);
        content[index++] = ByteUtils.getLowByte(this.subMessageType);
        if (data != null && data.length > 0) {
            System.arraycopy(data, 0, content, index, data.length);
        }
        return content;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

