/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AbstractBidibGuestMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class GuestResponseSentMessage
extends AbstractBidibGuestMessage {
    private int messageType;
    private int contentStartIndex;
    private int ackSequence;
    private int result;

    public GuestResponseSentMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int ackSequence, int result, byte ... wrappedContent) throws ProtocolException {
        super(addr, num, targetMode, targetModeUniqueId, 82, () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(targetMode.getType());
            GuestResponseSentMessage.appendTargetModeUniqueId(baos, targetModeUniqueId);
            baos.write(ByteUtils.getLowByte(ackSequence));
            baos.write(ByteUtils.getLowByte(result));
            if (wrappedContent != null && wrappedContent.length > 0) {
                try {
                    baos.write(wrappedContent);
                }
                catch (IOException ex) {
                    throw new ProtocolException("Add wrapped content to message data failed.");
                }
            }
            return baos.toByteArray();
        });
        this.ackSequence = ackSequence;
        this.result = result;
        if (wrappedContent != null && wrappedContent.length > 0) {
            this.messageType = ByteUtils.getInt(wrappedContent[0]);
        }
        this.contentStartIndex = 1 + (targetModeUniqueId != null ? targetModeUniqueId.length + 1 : 1) + 1;
    }

    public GuestResponseSentMessage(byte[] message) throws ProtocolException {
        super(message);
        int index = this.indexHolder[0];
        this.ackSequence = ByteUtils.getInt(this.getData()[index]);
        this.result = ByteUtils.getInt(this.getData()[++index]);
        this.contentStartIndex = ++index;
        if (index < this.getData().length) {
            this.messageType = ByteUtils.getInt(this.getData()[index]);
            ++index;
        }
    }

    @Override
    protected byte[] extractTargetModeUniqueId() throws ProtocolException {
        return ByteUtils.subArray(this.getData(), 1, 5);
    }

    @Override
    public String getName() {
        return "MSG_GUEST_RESP_SENT";
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getAckSequence() {
        return this.ackSequence;
    }

    public int getResult() {
        return this.result;
    }

    public int getContentStartIndex() {
        return this.contentStartIndex;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

