/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AbstractBidibGuestMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class GuestResponseSubscriptionCountMessage
extends AbstractBidibGuestMessage {
    private int ackSequence;
    private int result;
    private int nodeCount;

    public GuestResponseSubscriptionCountMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int ackSequence, int result, int nodeCount) throws ProtocolException {
        super(addr, num, targetMode, targetModeUniqueId, 80, () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(targetMode.getType());
            GuestResponseSubscriptionCountMessage.appendTargetModeUniqueId(baos, targetModeUniqueId);
            baos.write(ByteUtils.getLowByte(ackSequence));
            baos.write(ByteUtils.getLowByte(result));
            baos.write(ByteUtils.getLowByte(nodeCount));
            baos.write(ByteUtils.getHighByte(nodeCount));
            return baos.toByteArray();
        });
        this.ackSequence = ackSequence;
        this.result = result;
        this.nodeCount = nodeCount;
    }

    public GuestResponseSubscriptionCountMessage(byte[] message) throws ProtocolException {
        super(message);
        int index = this.indexHolder[0];
        this.ackSequence = ByteUtils.getInt(this.getData()[index]);
        this.result = ByteUtils.getInt(this.getData()[++index]);
        int n = ++index;
        int n2 = ++index;
        ++index;
        this.nodeCount = ByteUtils.getWord(this.getData()[n], this.getData()[n2]);
    }

    @Override
    public String getName() {
        return "MSG_GUEST_RESP_SUBSCRIPTION_COUNT";
    }

    @Override
    public byte[] getTargetUniqueId() throws ProtocolException {
        return this.getTargetModeUniqueIdIgnoreMode();
    }

    public int getAckSequence() {
        return this.ackSequence;
    }

    public int getResult() {
        return this.result;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

