/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AbstractBidibGuestMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class GuestResponseSubscriptionMessage
extends AbstractBidibGuestMessage {
    private int ackSequence;
    private int result;
    private int subscription;

    public GuestResponseSubscriptionMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int ackSequence, int result, int subscription) throws ProtocolException {
        super(addr, num, targetMode, targetModeUniqueId, 81, () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(targetMode.getType());
            GuestResponseSubscriptionMessage.appendTargetModeUniqueId(baos, targetModeUniqueId);
            baos.write(ByteUtils.getLowByte(ackSequence));
            baos.write(ByteUtils.getLowByte(result));
            baos.write(ByteUtils.getLowByte(subscription));
            baos.write(ByteUtils.getHighByte(subscription));
            return baos.toByteArray();
        });
        this.ackSequence = ackSequence;
        this.result = result;
        this.subscription = subscription;
    }

    public GuestResponseSubscriptionMessage(byte[] message) throws ProtocolException {
        super(message);
        int index = this.indexHolder[0];
        this.ackSequence = ByteUtils.getInt(this.getData()[index++]);
        this.result = ByteUtils.getInt(this.getData()[index++]);
        this.subscription = ByteUtils.getWord(this.getData()[index++], this.getData()[index++]);
    }

    @Override
    protected byte[] extractTargetModeUniqueId() throws ProtocolException {
        return ByteUtils.subArray(this.getData(), 1, 5);
    }

    @Override
    public String getName() {
        return "MSG_GUEST_RESP_SUBSCRIPTION";
    }

    public int getAckSequence() {
        return this.ackSequence;
    }

    public int getResult() {
        return this.result;
    }

    public int getSubscription() {
        return this.subscription;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

