/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibBulkCommand;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcConfigGetMessage
extends BidibCommandMessage
implements BidibBulkCommand {
    protected LcConfigGetMessage(BidibPort bidibPort) {
        super(0, 66, bidibPort.getValues());
    }

    public LcConfigGetMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_LC_CONFIG_GET";
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(this.getData()[0]);
            }
        }
        return outputType;
    }

    public int getPortNumber(PortModelEnum portModel) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(this.getData()[0], this.getData()[0] & 0x7F);
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(this.getData()[0]);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(this.getData()[1], 127);
            }
        }
        return portNumber;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    @Override
    public Integer[] getExpectedBulkResponseTypes() {
        return new Integer[]{LcConfigResponse.TYPE, LcNotAvailableResponse.TYPE};
    }
}

