/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcConfigResponse
extends BidibMessage {
    public static final Integer TYPE = 194;

    protected LcConfigResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 6) {
            throw new ProtocolException("No valid MSG_LC_CONFIG received.");
        }
    }

    public LcConfigResponse(byte[] addr, int num, BidibPort bidibPort, byte[] config) throws ProtocolException {
        this(addr, num, 194, ByteUtils.concat(bidibPort.getValues(), config));
    }

    public LcConfigResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 6) {
            throw new ProtocolException("No valid MSG_LC_CONFIG received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_CONFIG";
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(this.getData()[0]);
            }
        }
        return outputType;
    }

    public int getPortNumber(PortModelEnum portModel) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(this.getData()[0], this.getData()[0] & 0x7F);
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(this.getData()[0]);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(this.getData()[1], 127);
            }
        }
        return portNumber;
    }

    public LcConfig getLcConfig() {
        byte[] data = this.getData();
        BidibPort bidibPort = BidibPort.prepareBidibPort(data[0], data[1]);
        return new LcConfig(bidibPort, ByteUtils.getInt(data[2]), ByteUtils.getInt(data[3]), ByteUtils.getInt(data[4]), ByteUtils.getInt(data[5]));
    }
}

