/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcConfigSetMessage
extends BidibCommandMessage {
    public LcConfigSetMessage(PortModelEnum portModel, LcConfig config) {
        super(0, 65, config.getOutputType(portModel).getType(), ByteUtils.getLowByte(config.getOutputNumber(portModel)), ByteUtils.getLowByte(config.getValue1()), ByteUtils.getLowByte(config.getValue2()), ByteUtils.getLowByte(config.getValue3()), ByteUtils.getLowByte(config.getValue4()));
    }

    public LcConfigSetMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_LC_CONFIG_SET";
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        return PortModelEnum.getPortType(portModel, this.getData()[0]);
    }

    public int getPortNumber(PortModelEnum portModel) {
        return PortModelEnum.getPortNumber(portModel, this.getData()[0], this.getData()[1]);
    }

    public byte[] getPortConfig() {
        byte[] config = new byte[]{this.getData()[2], this.getData()[3], this.getData()[4], this.getData()[5]};
        return config;
    }

    public byte getValue1() {
        return this.getData()[2];
    }

    public byte getValue2() {
        return this.getData()[3];
    }

    public byte getValue3() {
        return this.getData()[4];
    }

    public byte getValue4() {
        return this.getData()[5];
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{LcConfigResponse.TYPE, LcNotAvailableResponse.TYPE};
    }
}

