/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.message.BidibMessage;

public class LcConfigXResponse
extends BidibMessage {
    public static final Integer TYPE = 198;

    protected LcConfigXResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_LC_CONFIGX received.");
        }
    }

    public LcConfigXResponse(byte[] addr, int num, LcConfigX lcConfigX, PortModelEnum portModelEnum) throws ProtocolException {
        this(addr, num, LcConfigX.getCodedPortConfig(null, lcConfigX, portModelEnum));
    }

    public LcConfigXResponse(byte[] addr, int num, byte[] config) throws ProtocolException {
        this(addr, num, 198, config);
    }

    public LcConfigXResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_LC_CONFIGX received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_CONFIGX";
    }

    public LcConfigX getLcConfigX(Logger logger) {
        byte[] data = this.getData();
        return LcConfigX.getLcConfigX(logger, data);
    }
}

