/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.message.BidibBulkCommand;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcConfigXSetMessage
extends BidibCommandMessage
implements BidibBulkCommand {
    public LcConfigXSetMessage(Logger logger, LcConfigX configX, PortModelEnum portModel) throws ProtocolException {
        super(0, 70, LcConfigX.getCodedPortConfig(logger, configX, portModel));
    }

    public LcConfigXSetMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_LC_CONFIGX_SET";
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(this.getData()[0]);
            }
        }
        return outputType;
    }

    public int getPortNumber(PortModelEnum portModel) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(this.getData()[0], this.getData()[0] & 0x7F);
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(this.getData()[0]);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(this.getData()[1], 127);
            }
        }
        return portNumber;
    }

    public LcConfigX getLcConfigX(Logger logger) {
        byte[] data = this.getData();
        return LcConfigX.getLcConfigX(logger, data);
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{LcConfigXResponse.TYPE, LcNotAvailableResponse.TYPE};
    }

    @Override
    public Integer[] getExpectedBulkResponseTypes() {
        return new Integer[]{LcConfigXResponse.TYPE, LcNotAvailableResponse.TYPE};
    }
}

