/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcKeyResponse
extends BidibMessage {
    public static final Integer TYPE = 195;

    protected LcKeyResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_LC_KEY received.");
        }
    }

    public LcKeyResponse(byte[] addr, int num, byte keyNum, byte keyState) throws ProtocolException {
        this(addr, num, 195, keyNum, keyState);
    }

    public LcKeyResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_LC_KEY received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_KEY";
    }

    public int getKeyNumber() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public int getKeyState() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public BidibPort getBidibPort() {
        return BidibPort.prepareBidibPort(PortModelEnum.type, LcOutputType.INPUTPORT, (int)this.getData()[0]);
    }

    public int getPortStatus() {
        return ByteUtils.getInt(this.getData()[1]);
    }
}

