/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.LcMacroParaValue;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcMacroParaResponse
extends BidibMessage {
    public static final Integer TYPE = 202;

    LcMacroParaResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_LC_MACRO_PARA received.");
        }
    }

    public LcMacroParaResponse(byte[] addr, int num, int macroNumber, int step, byte[] value) throws ProtocolException {
        this(addr, num, 202, ByteUtils.concat(new byte[]{ByteUtils.getLowByte(macroNumber), ByteUtils.getLowByte(step)}, value));
    }

    public LcMacroParaResponse(byte[] addr, int num, byte macroNumber, byte step, byte[] value) throws ProtocolException {
        this(addr, num, 202, ByteUtils.concat(new byte[]{macroNumber, step}, value));
    }

    public LcMacroParaResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_LC_MACRO_PARA received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_MACRO_PARA";
    }

    public int getMacroNumber() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public int getParameterIndex() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public LcMacroParaValue getLcMacroParaValue() {
        byte[] data = this.getData();
        byte[] result = new byte[data.length - 2];
        System.arraycopy(data, 2, result, 0, result.length);
        return new LcMacroParaValue(this.getMacroNumber(), this.getParameterIndex(), result);
    }
}

