/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.enums.LcMacroState;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcMacroStateResponse
extends BidibMessage {
    public static final Integer TYPE = 200;

    protected LcMacroStateResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_LC_MACRO_STATE received.");
        }
    }

    public LcMacroStateResponse(byte[] addr, int num, byte macroNumber, LcMacroState macroState) throws ProtocolException {
        this(addr, num, 200, macroNumber, macroState.getType());
    }

    public LcMacroStateResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_LC_MACRO_STATE received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_MACRO_STATE";
    }

    public int getMacroNumber() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public LcMacroState getMacroState() {
        return LcMacroState.valueOf(this.getData()[1]);
    }

    public String toExtendedString() {
        StringBuilder sb = new StringBuilder("[ ");
        sb.append(super.toString());
        sb.append(", macroNumber: ").append(this.getMacroNumber());
        sb.append(", macroState: ").append(this.getMacroState());
        return sb.toString();
    }
}

