/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcNotAvailableResponse
extends BidibMessage {
    public static final Integer TYPE = 193;

    protected LcNotAvailableResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_LC_NA received.");
        }
    }

    public LcNotAvailableResponse(byte[] addr, int num, BidibPort bidibPort) throws ProtocolException {
        this(addr, num, 193, bidibPort.getValues());
    }

    public LcNotAvailableResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_LC_NA received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_NA";
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(this.getData()[0]);
            }
        }
        return outputType;
    }

    public int getPortNumber(PortModelEnum portModel) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(this.getData()[0], this.getData()[1] & 0x7F);
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(this.getData()[0]);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(this.getData()[1], 127);
            }
        }
        return portNumber;
    }

    public BidibPort getBidibPort() {
        return BidibPort.prepareBidibPort(this.getData()[0], this.getData()[1]);
    }

    public Integer getErrorCode() {
        if (this.getData().length > 2) {
            return ByteUtils.getInt(this.getData()[2]);
        }
        return null;
    }
}

