/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcOutputMessage
extends BidibCommandMessage {
    public LcOutputMessage(BidibPort bidibPort, int status) {
        super(0, 64, ByteUtils.concat(bidibPort.getValues(), new byte[]{ByteUtils.getLowByte(status)}));
    }

    public LcOutputMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_LC_OUTPUT";
    }

    public LcOutputType getOutputType(PortModelEnum portModel) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(this.getData()[0]);
            }
        }
        return outputType;
    }

    public int getOutputNumber(PortModelEnum portModel) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(this.getData()[0], this.getData()[0] & 0x7F);
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(this.getData()[0]);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(this.getData()[1], 127);
            }
        }
        return portNumber;
    }

    public byte getOutputStatus() {
        return this.getData()[2];
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

