/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibBulkCommand;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcPortQueryAllMessage
extends BidibCommandMessage
implements BidibBulkCommand {
    private int expectedCountResponses;

    protected LcPortQueryAllMessage() {
        super(0, 63, new byte[0]);
    }

    protected LcPortQueryAllMessage(int portTypeMask, int rangeFrom, int rangeTo) {
        super(0, 63, ByteUtils.getLowByte(portTypeMask), ByteUtils.getHighByte(portTypeMask), ByteUtils.getLowByte(rangeFrom), ByteUtils.getHighByte(rangeFrom), ByteUtils.getLowByte(rangeTo), ByteUtils.getHighByte(rangeTo));
    }

    public LcPortQueryAllMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_LC_PORT_QUERY_ALL";
    }

    public int getPortTypeMask() {
        return ByteUtils.getInt(this.getData()[0], this.getData()[1]);
    }

    public int getPortRangeFrom(PortModelEnum portModel) {
        int portRangeFrom = PortModelEnum.getPortNumber(portModel, this.getData()[2], this.getData()[3]);
        if (portRangeFrom == -1) {
            portRangeFrom = 0;
        }
        return portRangeFrom;
    }

    public int getPortRangeTo(PortModelEnum portModel) {
        int portRangeTo = PortModelEnum.getPortNumber(portModel, this.getData()[4], this.getData()[5]);
        if (portRangeTo == -1) {
            portRangeTo = 65535;
        }
        return portRangeTo;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    @Override
    public Integer[] getExpectedBulkResponseTypes() {
        return new Integer[]{LcStatResponse.TYPE, LcNotAvailableResponse.TYPE};
    }

    @Override
    public int getExpectedCountResponses() {
        return this.expectedCountResponses;
    }

    public void setExpectedCountResponses(int expectedCountResponses) {
        this.expectedCountResponses = expectedCountResponses;
    }
}

