/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcStatResponse
extends BidibMessage {
    public static final Integer TYPE = 192;

    protected LcStatResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_LC_STAT received.");
        }
    }

    public LcStatResponse(byte[] addr, int num, BidibPort bidibPort, byte portStatus) throws ProtocolException {
        this(addr, num, 192, ByteUtils.concat(bidibPort.getValues(), new byte[]{portStatus}));
    }

    public LcStatResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_LC_STAT received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_LC_STAT";
    }

    public LcOutputType getPortType(PortModelEnum portModel) {
        return PortModelEnum.getPortType(portModel, this.getData()[0]);
    }

    public int getPortNumber(PortModelEnum portModel) {
        return PortModelEnum.getPortNumber(portModel, this.getData()[0], this.getData()[1]);
    }

    public BidibPort getBidibPort() {
        return BidibPort.prepareBidibPort(this.getData()[0], this.getData()[1]);
    }

    public int getPortStatus() {
        return ByteUtils.getInt(this.getData()[2]);
    }
}

