/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LocalLogonAckMessage
extends BidibCommandMessage {
    public static final Integer TYPE = 112;

    protected LocalLogonAckMessage(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
    }

    public LocalLogonAckMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    public LocalLogonAckMessage(int localNodeAddr, long uniqueId) throws ProtocolException {
        super(Node.ROOTNODE_ADDR, 0, 112, LocalLogonAckMessage.prepareLogonAckData(localNodeAddr, uniqueId));
    }

    private static byte[] prepareLogonAckData(int localNodeAddr, long uniqueId) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(localNodeAddr));
        try {
            out.write(ByteUtils.convertLongToUniqueId(uniqueId));
        }
        catch (IOException ex) {
            throw new ProtocolException("Convert uniqueId failed: " + ByteUtils.formatHexUniqueId(uniqueId));
        }
        return out.toByteArray();
    }

    @Override
    public String getName() {
        return "MSG_LOCAL_LOGON_ACK";
    }

    public int getNodeAddress() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public long getSenderUniqueId() {
        return ByteUtils.convertUniqueIdToLong(ByteUtils.subArray(this.getData(), 1, 7));
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    @Override
    public boolean isLocalMessage() {
        return true;
    }
}

