/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.nio.charset.StandardCharsets;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LocalLogonMessage
extends BidibCommandMessage {
    public static final Integer TYPE = 240;

    public LocalLogonMessage(long uniqueId) {
        super(0, 240, ByteUtils.getUniqueId(uniqueId));
    }

    public LocalLogonMessage(byte[] addr, int num, long uniqueId) throws ProtocolException {
        super(addr, num, 240, ByteUtils.getUniqueId(uniqueId));
    }

    public LocalLogonMessage(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
    }

    public LocalLogonMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_LOCAL_LOGON";
    }

    public String getEmitter() {
        return new String(this.getData(), StandardCharsets.ISO_8859_1);
    }

    public byte[] getUniqueId() {
        return this.getData();
    }

    public long getSenderUniqueId() {
        return ByteUtils.convertUniqueIdToLong(ByteUtils.subArray(this.getData(), 0, 7));
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    @Override
    public boolean isLocalMessage() {
        return true;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder("LocalLogonMessage[");
        sb.append("uniqueId=").append(ByteUtils.bytesToHex(this.getUniqueId()));
        return sb.toString();
    }
}

