/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LocalSyncMessage
extends BidibCommandMessage {
    public static final Integer TYPE = 116;

    public LocalSyncMessage(int systemTime) {
        super(0, 116, ByteUtils.getLowByte(systemTime), ByteUtils.getHighByte(systemTime));
    }

    public LocalSyncMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    public int getSystemTime() {
        return ByteUtils.getInt(this.getData()[0], this.getData()[1]);
    }

    @Override
    public String getName() {
        return "MSG_LOCAL_SYNC";
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    @Override
    public boolean isLocalMessage() {
        return true;
    }
}

