/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class NodeTabCountResponse
extends BidibMessage {
    public static final Integer TYPE = 136;

    protected NodeTabCountResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_NODETAB_COUNT received.");
        }
    }

    public NodeTabCountResponse(byte[] addr, int num, int tabCount) throws ProtocolException {
        this(addr, num, 136, ByteUtils.getLowByte(tabCount));
    }

    public NodeTabCountResponse(byte[] addr, int num, byte tabCount) throws ProtocolException {
        this(addr, num, 136, tabCount);
    }

    public NodeTabCountResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_NODETAB_COUNT received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_NODETAB_COUNT";
    }

    public int getCount() {
        return ByteUtils.getInt(this.getData()[0]);
    }
}

