/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class NodeTabResponse
extends BidibMessage {
    public static final Integer TYPE = 137;

    protected NodeTabResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 9) {
            throw new ProtocolException("No valid MSG_NODETAB received.");
        }
    }

    public NodeTabResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        this(addr, num, 137, ByteUtils.concat(new byte[]{ByteUtils.getLowByte(version), ByteUtils.getLowByte(localAddr)}, ByteUtils.getVidPidFromUniqueId(uniqueId)));
    }

    public NodeTabResponse(byte[] addr, int num, byte version, byte localAddr, long uniqueId) throws ProtocolException {
        this(addr, num, 137, ByteUtils.concat(new byte[]{version, localAddr}, ByteUtils.getVidPidFromUniqueId(uniqueId)));
    }

    public NodeTabResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 9) {
            throw new ProtocolException("No valid MSG_NODETAB received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_NODETAB";
    }

    public int getNodeTabVersion() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public int getLocalAddr() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public byte[] getUniqueId() {
        byte[] uniqueId = new byte[7];
        System.arraycopy(this.getData(), 2, uniqueId, 0, uniqueId.length);
        return uniqueId;
    }

    public Node getNode(Logger logger, byte[] parentAddress) {
        byte[] data = this.getData();
        byte[] addr = new byte[parentAddress.length + 1];
        byte[] uniqueId = new byte[7];
        if (parentAddress.length == 1 && parentAddress[0] == 0) {
            addr = new byte[]{data[1]};
        } else if (data[1] == 0) {
            addr = new byte[parentAddress.length];
            System.arraycopy(parentAddress, 0, addr, 0, parentAddress.length);
        } else {
            System.arraycopy(parentAddress, 0, addr, 0, parentAddress.length);
            addr[parentAddress.length] = data[1];
        }
        System.arraycopy(data, 2, uniqueId, 0, uniqueId.length);
        int version = ByteUtils.getInt(data[0]);
        Node node = Node.createNode(version, addr, ByteUtils.convertUniqueIdToLong(uniqueId));
        node.setLogger(logger);
        node.setRegistered(true);
        return node;
    }

    public static Node getNode(Logger logger, byte[] parentAddress, int localAddress, int version, byte[] uniqueId) {
        byte localAddr = ByteUtils.getLowByte(localAddress);
        byte[] addr = new byte[parentAddress.length + 1];
        if (parentAddress.length == 1 && parentAddress[0] == 0) {
            addr = new byte[]{localAddr};
        } else if (localAddr == 0) {
            addr = new byte[parentAddress.length];
            System.arraycopy(parentAddress, 0, addr, 0, parentAddress.length);
        } else {
            System.arraycopy(parentAddress, 0, addr, 0, parentAddress.length);
            addr[parentAddress.length] = localAddr;
        }
        Node node = Node.createNode(version, addr, ByteUtils.convertUniqueIdToLong(uniqueId));
        node.setLogger(logger);
        node.setRegistered(true);
        return node;
    }
}

