/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class StallResponse
extends BidibMessage {
    public static final Integer TYPE = 142;

    protected StallResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data != null && data.length < 1) {
            throw new ProtocolException("No valid MSG_STALL received: " + ByteUtils.bytesToHex(data));
        }
    }

    public StallResponse(byte[] addr, int num, byte data) throws ProtocolException {
        this(addr, num, 142, data);
    }

    public StallResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_STALL received: " + ByteUtils.bytesToHex(this.getData()));
        }
    }

    @Override
    public String getName() {
        return "MSG_STALL";
    }

    public boolean isStall() {
        byte[] data = this.getData();
        return data[0] == 1;
    }
}

