/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.nio.charset.StandardCharsets;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class StringResponse
extends BidibMessage {
    public static final Integer TYPE = 149;

    protected StringResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_STRING received.");
        }
    }

    public StringResponse(byte[] addr, int num, StringData stringData) throws ProtocolException {
        this(addr, num, ByteUtils.getLowByte(stringData.getNamespace()), ByteUtils.getLowByte(stringData.getIndex()), stringData.getValue());
    }

    public StringResponse(byte[] addr, int num, byte namespace, byte index, String data) throws ProtocolException {
        this(addr, num, 149, ByteUtils.concat(new byte[]{namespace, index, ByteUtils.getLowByte(data.length())}, data.getBytes(StandardCharsets.ISO_8859_1)));
    }

    public StringResponse(byte[] addr, int num, byte namespace, byte index, byte ... data) throws ProtocolException {
        this(addr, num, 149, ByteUtils.concat(new byte[]{namespace, index, ByteUtils.getLowByte(data.length)}, data));
    }

    public StringResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_STRING received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_STRING";
    }

    public StringData getStringData() {
        StringData stringData = new StringData();
        byte[] data = this.getData();
        stringData.setNamespace(ByteUtils.getInt(data[0]));
        stringData.setIndex(ByteUtils.getInt(data[1]));
        if (stringData.getNamespace() == 0) {
            stringData.setValue(ByteUtils.cstr(data, 2));
        } else {
            stringData.setValue(ByteUtils.cstrUTF8(data, 2));
        }
        return stringData;
    }
}

