/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.nio.charset.Charset;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class StringSetMessage
extends BidibCommandMessage {
    public StringSetMessage(int namespace, int stringId, String value) {
        super(0, 26, StringSetMessage.bstr(namespace, stringId, value));
    }

    public StringSetMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_STRING_SET";
    }

    private static byte[] bstr(int namespace, int stringId, String value) {
        if (value.length() > 127) {
            throw new IllegalArgumentException("Length of string exceeds 127.");
        }
        byte[] result = new byte[3 + value.length()];
        result[0] = ByteUtils.getLowByte(namespace);
        result[1] = ByteUtils.getLowByte(stringId);
        result[2] = ByteUtils.getLowByte(value.length());
        System.arraycopy(value.getBytes(Charset.forName("ISO-8859-1")), 0, result, 3, value.length());
        return result;
    }

    public int getNamespace() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public int getStringId() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public String getString() {
        return ByteUtils.cstr(this.getData(), 2);
    }

    public StringData getStringData() {
        StringData stringData = new StringData();
        byte[] data = this.getData();
        stringData.setNamespace(ByteUtils.getInt(data[0]));
        stringData.setIndex(ByteUtils.getInt(data[1]));
        stringData.setValue(ByteUtils.cstr(data, 2));
        return stringData;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{StringResponse.TYPE};
    }
}

