/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;

public class SysClockMessage
extends BidibCommandMessage {
    protected SysClockMessage(LocalDateTime date, int factor) {
        super(0, 24, SysClockMessage.getMinute(date.getMinute()), SysClockMessage.getHour(date.getHour()), SysClockMessage.getDay(date.getDayOfWeek()), SysClockMessage.getAccelerationFactor(factor));
    }

    public SysClockMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_SYS_CLOCK";
    }

    public static byte getAccelerationFactor(int factor) {
        if (factor > 63) {
            factor = 63;
        }
        return (byte)((factor | 0xC0) & 0xFF);
    }

    public static byte getDay(int day) {
        day = day == 0 ? 7 : (day + 5) % 7;
        byte ret = (byte)((day | 0x40) & 0x47);
        return ret;
    }

    public static byte getDay(DayOfWeek day) {
        int bidibDay = 0;
        bidibDay = day == null ? 7 : (day.getValue() + 6) % 7;
        byte ret = (byte)((bidibDay | 0x40) & 0x47);
        return ret;
    }

    public static byte getHour(int hour) {
        return (byte)((hour | 0x80) & 0x9F);
    }

    public static byte getMinute(int minute) {
        return (byte)(minute & 0x3F);
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

