/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SysErrorResponse
extends BidibMessage {
    public static final Integer TYPE = 134;
    private byte[] reasonData;

    public SysErrorResponse(byte[] addr, int num, SysErrorEnum sysError, byte ... reason) throws ProtocolException {
        this(addr, num, (int)TYPE, ByteUtils.concat(new byte[]{sysError.getType()}, reason));
    }

    protected SysErrorResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_SYS_ERROR received.");
        }
    }

    public SysErrorResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_SYS_ERROR received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_SYS_ERROR";
    }

    public int getErrorCode() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public byte[] getReasonData() {
        if (this.reasonData == null) {
            try {
                SysErrorEnum sysErrorEnum = SysErrorEnum.valueOf(this.getData()[0]);
                switch (sysErrorEnum) {
                    case BIDIB_ERR_NONE: {
                        break;
                    }
                    case BIDIB_ERR_TXT: {
                        this.reasonData = ByteUtils.cstr(this.getData(), 1).getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    case BIDIB_ERR_CRC: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_SIZE: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_SEQUENCE: {
                        if (this.getData().length > 4) {
                            this.reasonData = new byte[]{this.getData()[1], this.getData()[2], this.getData()[3], this.getData()[4]};
                            break;
                        }
                        if (this.getData().length > 2) {
                            this.reasonData = new byte[]{this.getData()[1], this.getData()[2]};
                            break;
                        }
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_PARAMETER: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_BUS: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_ADDRSTACK: {
                        this.reasonData = Arrays.copyOfRange(this.getData(), 1, this.getData().length);
                        break;
                    }
                    case BIDIB_ERR_IDDOUBLE: {
                        if (this.getData().length <= 7) break;
                        this.reasonData = Arrays.copyOfRange(this.getData(), 1, 8);
                        break;
                    }
                    case BIDIB_ERR_SUBCRC: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_SUBTIME: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_SUBPAKET: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_OVERRUN: {
                        break;
                    }
                    case BIDIB_ERR_HW: {
                        this.reasonData = new byte[]{this.getData()[1]};
                        break;
                    }
                    case BIDIB_ERR_RESET_REQUIRED: {
                        break;
                    }
                    case BIDIB_ERR_NO_SECACK_BY_HOST: {
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.reasonData;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SysErrorResponse) {
            SysErrorResponse other = (SysErrorResponse)obj;
            if (!Arrays.equals(this.reasonData, other.reasonData)) {
                return false;
            }
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.reasonData);
    }
}

