/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SysMagicResponse
extends BidibMessage {
    public static final Integer TYPE = 129;

    public SysMagicResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_SYS_MAGIC received.");
        }
    }

    public SysMagicResponse(byte[] addr, int num, int magic) throws ProtocolException {
        this(addr, num, 129, ByteUtils.getLowByte(magic), ByteUtils.getHighByte(magic));
    }

    public SysMagicResponse(byte[] addr, int num, byte ... data) throws ProtocolException {
        this(addr, num, 129, data);
    }

    public SysMagicResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_SYS_MAGIC received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_SYS_MAGIC";
    }

    public int getMagic() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[0], data[1]);
    }
}

