/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SysPVersionResponse
extends BidibMessage {
    public static final Integer TYPE = 131;

    protected SysPVersionResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_SYS_P_VERSION received.");
        }
    }

    public SysPVersionResponse(byte[] addr, int num, ProtocolVersion protocolVersion) throws ProtocolException {
        this(addr, num, protocolVersion.getMajorVersion(), protocolVersion.getMinorVersion());
    }

    public SysPVersionResponse(byte[] addr, int num, int majorVersion, int minorVersion) throws ProtocolException {
        this(addr, num, 131, ByteUtils.getLowByte(minorVersion), ByteUtils.getLowByte(majorVersion));
    }

    public SysPVersionResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_SYS_P_VERSION received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_SYS_P_VERSION";
    }

    public ProtocolVersion getVersion() {
        byte[] data = this.getData();
        return new ProtocolVersion(ByteUtils.getInt(data[1]), ByteUtils.getInt(data[0]));
    }
}

