/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SysPongResponse
extends BidibMessage {
    public static final Integer TYPE = 130;

    protected SysPongResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_SYS_PONG received.");
        }
    }

    public SysPongResponse(byte[] addr, int num, int marker) throws ProtocolException {
        this(addr, num, 130, ByteUtils.getLowByte(marker));
    }

    public SysPongResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_SYS_PONG received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_SYS_PONG";
    }

    public int getMarker() {
        return ByteUtils.getInt(this.getData()[0]);
    }
}

