/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SysSwVersionResponse
extends BidibMessage {
    public static final Integer TYPE = 133;

    protected SysSwVersionResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_SYS_SW_VERSION received.");
        }
    }

    public SysSwVersionResponse(byte[] addr, int num, SoftwareVersion softwareVersion) throws ProtocolException {
        this(addr, num, 133, softwareVersion.asByteArray());
    }

    public SysSwVersionResponse(byte[] addr, int num, byte[] version) throws ProtocolException {
        this(addr, num, 133, version);
    }

    public SysSwVersionResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_SYS_SW_VERSION received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_SYS_SW_VERSION";
    }

    public SoftwareVersion getVersion() {
        byte[] data = this.getData();
        SoftwareVersion softwareVersion = new SoftwareVersion(ByteUtils.getInt(data[2]), ByteUtils.getInt(data[1]), ByteUtils.getInt(data[0]));
        if (data.length > 3) {
            for (int index = 3; index < data.length; index += 3) {
                SoftwareVersion childVersion = new SoftwareVersion(ByteUtils.getInt(data[index + 2]), ByteUtils.getInt(data[index + 1]), ByteUtils.getInt(data[index]));
                softwareVersion.addChildVersion(childVersion);
            }
        }
        return softwareVersion;
    }
}

