/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SysUniqueIdResponse
extends BidibMessage {
    public static final Integer TYPE = 132;

    protected SysUniqueIdResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 7) {
            throw new ProtocolException("No valid MSG_SYS_UNIQUE_ID received.");
        }
    }

    public SysUniqueIdResponse(byte[] addr, int num, long uniqueId) throws ProtocolException {
        this(addr, num, 132, ByteUtils.getUniqueId(uniqueId));
    }

    public SysUniqueIdResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 7) {
            throw new ProtocolException("No valid MSG_SYS_UNIQUE_ID received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_SYS_UNIQUE_ID";
    }

    public byte[] getUniqueId() {
        return this.getData();
    }

    public Long getConfigFingerPrint() {
        Long configFingerPrint = null;
        if (this.getData() != null && this.getData().length > 7) {
            configFingerPrint = ByteUtils.getDWORD(this.getData(), 7);
        }
        return configFingerPrint;
    }
}

