/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class VendorResponse
extends BidibMessage {
    public static final Integer TYPE = 147;

    protected VendorResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_VENDOR received.");
        }
    }

    public VendorResponse(byte[] addr, int num, String name, String value) throws ProtocolException {
        this(addr, num, 147, ByteUtils.bstr(name, value));
    }

    public VendorResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_VENDOR received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_VENDOR";
    }

    public VendorData getVendorData() {
        VendorData result = new VendorData();
        byte[] data = this.getData();
        result.setName(ByteUtils.cstr(data, 0));
        result.setValue(ByteUtils.cstr(data, result.getName().length() + 1));
        return result;
    }
}

