/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.VendorData;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class VendorSetMessage
extends BidibCommandMessage {
    public VendorSetMessage(String cvName, String cvValue) {
        super(0, 22, ByteUtils.bstr(cvName, cvValue));
    }

    public VendorSetMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_VENDOR_SET";
    }

    public VendorData getVendorData() {
        VendorData result = new VendorData();
        byte[] data = this.getData();
        result.setName(ByteUtils.cstr(data, 0));
        result.setValue(ByteUtils.cstr(data, result.getName().length() + 1));
        return result;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{VendorResponse.TYPE};
    }
}

