/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message.netbidib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.LinkDescriptorEnum;
import org.bidib.jbidibc.messages.enums.NetBidibRole;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;

public class LocalLinkMessage
extends NetBidibCommandMessage {
    public static final Integer TYPE = 255;

    public LocalLinkMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    public LocalLinkMessage(long uniqueId) throws ProtocolException {
        this(Node.ROOTNODE_ADDR, 0, uniqueId);
    }

    public LocalLinkMessage(byte[] addr, int num, long uniqueId) throws ProtocolException {
        super(addr, num, 255, ByteUtils.concat(new byte[]{ByteUtils.getLowByte(255)}, NodeUtils.getUniqueId(uniqueId)));
    }

    public LocalLinkMessage(int descriptor, String name) throws ProtocolException {
        this(Node.ROOTNODE_ADDR, 0, descriptor, name);
    }

    public LocalLinkMessage(byte[] addr, int num, int descriptor, String name) throws ProtocolException {
        super(addr, num, 255, LocalLinkMessage.prepareName(descriptor, name));
    }

    public LocalLinkMessage(NetBidibRole netBidibRole) throws ProtocolException {
        this(Node.ROOTNODE_ADDR, 0, 127, netBidibRole);
    }

    public LocalLinkMessage(byte[] addr, int num, int descriptor, NetBidibRole netBidibRole) throws ProtocolException {
        super(addr, num, 255, LocalLinkMessage.prepareRole(descriptor, netBidibRole));
    }

    public LocalLinkMessage(ProtocolVersion pVersion) throws ProtocolException {
        this(Node.ROOTNODE_ADDR, 0, 128, pVersion);
    }

    public LocalLinkMessage(byte[] addr, int num, int descriptor, ProtocolVersion pVersion) throws ProtocolException {
        super(addr, num, 255, LocalLinkMessage.prepareProtVersion(descriptor, pVersion));
    }

    public LocalLinkMessage(long senderUniqueId, long receiverUniqueId, int pairingTimeout) throws ProtocolException {
        this(Node.ROOTNODE_ADDR, 0, 252, senderUniqueId, receiverUniqueId, pairingTimeout);
    }

    public LocalLinkMessage(int descriptor, long senderUniqueId, long receiverUniqueId) throws ProtocolException {
        this(Node.ROOTNODE_ADDR, 0, descriptor, senderUniqueId, receiverUniqueId, null);
    }

    public LocalLinkMessage(byte[] addr, int num, int descriptor, long senderUniqueId, long receiverUniqueId, Integer pairingTimeout) throws ProtocolException {
        super(addr, num, 255, LocalLinkMessage.prepareLinkStatus(descriptor, senderUniqueId, receiverUniqueId, pairingTimeout));
    }

    private static byte[] prepareLinkStatus(int descriptor, long senderUniqueId, long receiverUniqueId, Integer pairingTimeout) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(descriptor));
        try {
            out.write(ByteUtils.convertLongToUniqueId(senderUniqueId));
        }
        catch (IOException ex) {
            throw new ProtocolException("Convert senderUniqueId failed: " + ByteUtils.formatHexUniqueId(senderUniqueId));
        }
        try {
            out.write(ByteUtils.convertLongToUniqueId(receiverUniqueId));
        }
        catch (IOException ex) {
            throw new ProtocolException("Convert receiverUniqueId failed: " + ByteUtils.formatHexUniqueId(receiverUniqueId));
        }
        if (pairingTimeout != null) {
            out.write(ByteUtils.getLowByte(pairingTimeout).byteValue());
        }
        return out.toByteArray();
    }

    private static byte[] prepareName(int descriptor, String name) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(descriptor));
        try {
            if (StringUtils.isNotBlank(name)) {
                out.write(ByteUtils.getLowByte(name.length()));
                out.write(ByteUtils.toByteArray(name));
            } else {
                out.write(ByteUtils.getLowByte(0));
            }
        }
        catch (IOException ex) {
            throw new ProtocolException("Convert name failed: " + name);
        }
        return out.toByteArray();
    }

    private static byte[] prepareProtVersion(int descriptor, ProtocolVersion pVersion) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(descriptor));
        try {
            out.write(pVersion.toByteArray());
        }
        catch (IOException ex) {
            throw new ProtocolException("Convert protocolVersion failed: " + pVersion);
        }
        return out.toByteArray();
    }

    private static byte[] prepareRole(int descriptor, NetBidibRole netBidibRole) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(descriptor));
        out.write(ByteUtils.getLowByte(netBidibRole.getType()));
        return out.toByteArray();
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    public int getLinkDescriptor() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public long getSenderUniqueId() {
        return ByteUtils.convertUniqueIdToLong(ByteUtils.subArray(this.getData(), 1, 7));
    }

    public long getReceiverUniqueId() {
        return ByteUtils.convertUniqueIdToLong(ByteUtils.subArray(this.getData(), 8, 7));
    }

    public String getProdString() {
        try {
            return ByteUtils.cstr(this.getData(), 1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public ProtocolVersion getProtocolVersion() {
        int versionL = ByteUtils.getInt(this.getData()[1]);
        int versionH = ByteUtils.getInt(this.getData()[2]);
        ProtocolVersion pVersion = new ProtocolVersion(versionH, versionL);
        return pVersion;
    }

    public NetBidibRole getNetBidibRole() {
        int role = ByteUtils.getInt(this.getData()[1]);
        return NetBidibRole.valueOf(role);
    }

    public Integer getPairingTimeout() {
        if (this.getLinkDescriptor() == 252 && this.getData().length > 15) {
            return ByteUtils.getInt(this.getData()[15]);
        }
        return null;
    }

    @Override
    protected void appendToStringDescriptor(StringBuilder sb) {
        sb.append("(").append(LinkDescriptorEnum.valueOf(this.getLinkDescriptor())).append(")");
    }
}

