/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message.netbidib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LocalProtocolSignatureMessage
extends NetBidibCommandMessage {
    public static final Integer TYPE = 254;
    public static final String EMITTER_PREFIX_BIDIB = "BiDiB";

    public LocalProtocolSignatureMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    public LocalProtocolSignatureMessage(byte[] addr, int num, String requestor) throws ProtocolException {
        super(addr, num, 254, LocalProtocolSignatureMessage.prepareRequestorName(requestor));
    }

    public LocalProtocolSignatureMessage(String requestor) throws ProtocolException {
        super(Node.ROOTNODE_ADDR, 0, 254, LocalProtocolSignatureMessage.prepareRequestorName(requestor));
    }

    private static byte[] prepareRequestorName(String requestor) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(ByteUtils.toByteArray(requestor));
        }
        catch (IOException ex) {
            throw new ProtocolException("Convert requestor name failed: " + requestor);
        }
        return out.toByteArray();
    }

    public String getRequestorName() {
        int length = this.getData().length;
        return ByteUtils.getString(this.getData(), 0, length);
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

