/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message.netbidib;

import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.NetBidibRole;
import org.bidib.jbidibc.messages.message.netbidib.BidibLinkData;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class NetBidibLinkData
implements BidibLinkData {
    private final PartnerType partnerType;
    private String requestorName;
    private Long uniqueId;
    private String prodString;
    private String userString;
    private ProtocolVersion protocolVersion;
    private NetBidibRole netBidibRole;
    private Integer requestedPairingTimeout;
    private PairingStatus pairingStatus = PairingStatus.UNKNOWN;
    private LogonStatus logonStatus = LogonStatus.LOGGED_OFF;

    public NetBidibLinkData(PartnerType partnerType) {
        this.partnerType = partnerType;
    }

    @Override
    public PartnerType getPartnerType() {
        return this.partnerType;
    }

    @Override
    public String getRequestorName() {
        return this.requestorName;
    }

    @Override
    public void setRequestorName(String requestorName) {
        this.requestorName = requestorName;
    }

    @Override
    public Long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(Long uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public String getProdString() {
        return this.prodString;
    }

    @Override
    public void setProdString(String prodString) {
        this.prodString = prodString;
    }

    @Override
    public String getUserString() {
        return this.userString;
    }

    @Override
    public void setUserString(String userString) {
        this.userString = userString;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public NetBidibRole getNetBidibRole() {
        return this.netBidibRole;
    }

    @Override
    public void setNetBidibRole(NetBidibRole netBidibRole) {
        this.netBidibRole = netBidibRole;
    }

    @Override
    public PairingStatus getPairingStatus() {
        return this.pairingStatus;
    }

    @Override
    public void setPairingStatus(PairingStatus pairingStatus) {
        this.pairingStatus = pairingStatus;
    }

    @Override
    public LogonStatus getLogonStatus() {
        return this.logonStatus;
    }

    @Override
    public void setLogonStatus(LogonStatus logonStatus) {
        this.logonStatus = logonStatus;
    }

    @Override
    public Integer getRequestedPairingTimeout() {
        return this.requestedPairingTimeout;
    }

    @Override
    public void setRequestedPairingTimeout(Integer requestedPairingTimeout) {
        this.requestedPairingTimeout = requestedPairingTimeout;
    }

    @Override
    public void clear(boolean clearRequestor) {
        if (clearRequestor) {
            this.requestorName = null;
        }
        this.uniqueId = null;
        this.prodString = null;
        this.userString = null;
        this.protocolVersion = null;
        this.netBidibRole = null;
        this.pairingStatus = PairingStatus.UNKNOWN;
        this.logonStatus = LogonStatus.LOGGED_OFF;
        this.requestedPairingTimeout = null;
    }

    @Override
    public boolean isLinkDataValid() {
        boolean valid = this.uniqueId != null;
        valid = valid && this.requestorName != null;
        valid = valid && this.prodString != null;
        valid = valid && this.userString != null;
        valid = valid && this.protocolVersion != null;
        return valid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BidibLinkData[");
        sb.append("partnerType=").append((Object)this.partnerType);
        sb.append(",requestorName=").append(this.requestorName);
        sb.append(",uniqueId=").append(ByteUtils.getUniqueIdAsString(this.uniqueId));
        sb.append(",prodString=").append(this.prodString);
        sb.append(",userString=").append(this.userString);
        sb.append(",protocolVersion=").append(this.protocolVersion);
        sb.append(",netBidibRole=").append(this.netBidibRole);
        sb.append(",pairingStatus=").append((Object)this.pairingStatus);
        sb.append(",logonStatus=").append((Object)this.logonStatus);
        sb.append(",requestedPairingTimeout=").append(this.requestedPairingTimeout).append("]");
        return sb.toString();
    }

    public static enum LogonStatus {
        LOGGED_OFF,
        LOGGED_ON;

    }

    public static enum PairingStatus {
        UNKNOWN,
        UNPAIRED,
        PAIRING_REQUESTED,
        PAIRING_REQUEST_ACKN,
        PAIRED,
        WITHDRAWN;

    }

    public static enum PartnerType {
        LOCAL,
        REMOTE;

    }
}

