/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.port;

import java.util.Map;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortType;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;

public class PortConfigUtils {
    public static int toPortTypeMask(LcOutputType lcOutputType) {
        int portTypeMask = 1 << lcOutputType.getType();
        return portTypeMask;
    }

    public static boolean isSupportsPortType(LcOutputType portType, int portTypeMask) {
        boolean isSupportsPortType = (portTypeMask & 1 << portType.getType()) == 1 << portType.getType();
        return isSupportsPortType;
    }

    public static boolean isSupportsPortType(PortType portType, int portTypeMask) {
        boolean isSupportsPortType = (portTypeMask & 1 << portType.getType()) == 1 << portType.getType();
        return isSupportsPortType;
    }

    public static boolean isSupportsSwitchPort(int portTypeMask) {
        boolean isSupportsSwitchPort = (portTypeMask & 1) == 1;
        return isSupportsSwitchPort;
    }

    public static boolean isSupportsSwitchPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsSwitchPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsInputPort(int portTypeMask) {
        boolean isSupportsInputPort = (portTypeMask & 0x8000) == 32768;
        return isSupportsInputPort;
    }

    public static boolean isSupportsInputPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsInputPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsServoPort(int portTypeMask) {
        boolean isSupportsServoPort = (portTypeMask & 4) == 4;
        return isSupportsServoPort;
    }

    public static boolean isSupportsServoPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsServoPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsLightPort(int portTypeMask) {
        boolean isSupportsLightPort = (portTypeMask & 2) == 2;
        return isSupportsLightPort;
    }

    public static boolean isSupportsLightPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsLightPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsAnalogPort(int portTypeMask) {
        boolean isSupportsAnalogPort = (portTypeMask & 0x20) == 32;
        return isSupportsAnalogPort;
    }

    public static boolean isSupportsAnalogPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsAnalogPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsBacklightPort(int portTypeMask) {
        boolean isSupportsBacklightPort = (portTypeMask & 0x40) == 64;
        return isSupportsBacklightPort;
    }

    public static boolean isSupportsBacklightPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsBacklightPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsSoundPort(int portTypeMask) {
        boolean isSupportsSoundPort = (portTypeMask & 8) == 8;
        return isSupportsSoundPort;
    }

    public static boolean isSupportsSoundPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsSoundPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsMotorPort(int portTypeMask) {
        boolean isSupportsMotorPort = (portTypeMask & 0x10) == 16;
        return isSupportsMotorPort;
    }

    public static boolean isSupportsMotorPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsMotorPort(reconfig.getPortMap());
        }
        return false;
    }

    public static boolean isSupportsSwitchPairPort(int portTypeMask) {
        boolean isSupportsSwitchPairPort = (portTypeMask & 0x80) == 128;
        return isSupportsSwitchPairPort;
    }

    public static boolean isSupportsSwitchPairPort(Map<Byte, PortConfigValue<?>> portConfig) {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)PortConfigUtils.getPortConfig(portConfig, (byte)-127);
        if (reconfig != null) {
            return PortConfigUtils.isSupportsSwitchPairPort(reconfig.getPortMap());
        }
        return false;
    }

    private static <T> T getPortConfig(Map<Byte, PortConfigValue<?>> portConfig, Byte key) {
        try {
            PortConfigValue<?> portConfigValue = portConfig.get(key);
            if (portConfigValue != null) {
                return (T)portConfig.get(key);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }
}

