/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.port;

import java.util.Map;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;

public class PortMapUtils {
    private PortMapUtils() {
    }

    public static boolean supportsPortType(LcOutputType lcOutputType, Map<Byte, PortConfigValue<?>> portConfigX) {
        ReconfigPortConfigValue reconfigPortConfigValue = (ReconfigPortConfigValue)portConfigX.get((byte)-127);
        if (reconfigPortConfigValue != null) {
            return PortMapUtils.supportsPortType(lcOutputType, reconfigPortConfigValue);
        }
        return false;
    }

    public static boolean supportsPortType(LcOutputType lcOutputType, ReconfigPortConfigValue reconfigPortConfigValue) {
        boolean supportsPortType = false;
        int portMap = reconfigPortConfigValue.getPortMap();
        switch (lcOutputType) {
            case SWITCHPORT: {
                supportsPortType = (portMap >> 0 & 1) == 1;
                break;
            }
            case LIGHTPORT: {
                supportsPortType = (portMap >> 1 & 1) == 1;
                break;
            }
            case SERVOPORT: {
                supportsPortType = (portMap >> 2 & 1) == 1;
                break;
            }
            case SOUNDPORT: {
                supportsPortType = (portMap >> 3 & 1) == 1;
                break;
            }
            case MOTORPORT: {
                supportsPortType = (portMap >> 4 & 1) == 1;
                break;
            }
            case ANALOGPORT: {
                supportsPortType = (portMap >> 5 & 1) == 1;
                break;
            }
            case BACKLIGHTPORT: {
                supportsPortType = (portMap >> 6 & 1) == 1;
                break;
            }
            case SWITCHPAIRPORT: {
                supportsPortType = (portMap >> 7 & 1) == 1;
                break;
            }
            case INPUTPORT: {
                supportsPortType = (portMap >> 15 & 1) == 1;
                break;
            }
        }
        return supportsPortType;
    }

    public static boolean supportsPortRemapping(ReconfigPortConfigValue reconfigPortConfigValue) {
        int portMap = reconfigPortConfigValue.getPortMap();
        return Integer.bitCount(portMap) > 1;
    }
}

