/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.port;

import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class ReconfigPortConfigValue
implements PortConfigValue<Integer> {
    private final Integer value;

    public ReconfigPortConfigValue(Integer value) {
        this.value = value;
    }

    public ReconfigPortConfigValue(int portType, int portMap) {
        this.value = (portMap & 0xFFFF) << 8 | portType & 0xFF;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public LcOutputType getCurrentOutputType() {
        byte type = (byte)(this.value & 0xFF);
        return LcOutputType.valueOf(type);
    }

    public int getPortMap() {
        int portMap = this.value >> 8 & 0xFFFF;
        return portMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReconfigPortConfigValue)) {
            return false;
        }
        ReconfigPortConfigValue other = (ReconfigPortConfigValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReconfigPortConfigValue, outputType: ").append(this.getCurrentOutputType()).append(", portMap: ").append(ByteUtils.intToHex(this.getPortMap()));
        return sb.toString();
    }
}

