/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.utils;

import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.logger.Logger;

public class AccessoryStateUtils {
    public static boolean hasError(byte execute) {
        return (execute & 0x80) == 128;
    }

    public static String getOperationResult(byte execute) {
        StringBuilder sb = new StringBuilder();
        switch (execute & 1) {
            case 0: {
                sb.append(" => Reached end position.");
                break;
            }
            case 1: {
                sb.append(" => End position not yet reached. Check WAIT.");
                break;
            }
            default: {
                sb.append(" => Unknown.");
            }
        }
        switch (execute & 2) {
            case 0: {
                sb.append(" => End position is verified by feedback.");
                break;
            }
            case 2: {
                sb.append(" => No control of end position possible.");
                break;
            }
            default: {
                sb.append(" => Unknown.");
            }
        }
        return sb.toString();
    }

    public static AccessoryExecutionState getExecutionState(Integer aspect, byte execute, Logger logger) {
        AccessoryExecutionState executionState = null;
        if ((execute & 0x80) == 0) {
            switch (execute & 3) {
                case 0: 
                case 2: {
                    executionState = AccessoryExecutionState.SUCCESSFUL;
                    break;
                }
                default: {
                    executionState = AccessoryExecutionState.RUNNING;
                }
            }
            if (aspect == null || aspect == 255) {
                if (logger != null) {
                    logger.info("The current aspect is unknown. Maybe the accessory was not initialized after startup of the node.", new Object[0]);
                }
                executionState = AccessoryExecutionState.UNKNOWN;
            }
        } else {
            executionState = AccessoryExecutionState.ERROR;
        }
        return executionState;
    }

    public static boolean hasMoreErrors(byte wait) {
        return (wait & 0x40) == 64;
    }

    public static ErrorAccessoryState getErrorState(byte wait) {
        return ErrorAccessoryState.valueOf(wait);
    }

    public static enum ErrorAccessoryState {
        NO_MORE_ERROR(0),
        COMMAND_NOT_EXECUTABLE_UNKNOWN_COMMAND_OR_ASPECT(1),
        POWER_CONSUMPTION_HIGH(2),
        POWER_SUPPLY_BELOW_LIMITS(3),
        FUSE_BLOWN(4),
        TEMPERATURE_TOO_HIGH(5),
        FEEDBACK_ERROR_UNWANTED_CHANGE_POSITION(6),
        MANUAL_CONTROL(7),
        BULB_OUT_OF_ORDER(16),
        SERVO_OUT_OF_ORDER(32),
        INTERNAL_ERROR(63);

        private final byte errorCode;

        private ErrorAccessoryState(int errorCode) {
            this.errorCode = (byte)errorCode;
        }

        public static ErrorAccessoryState valueOf(byte wait) {
            ErrorAccessoryState result = null;
            for (ErrorAccessoryState e : ErrorAccessoryState.values()) {
                if (e.errorCode != (wait & 0x3F)) continue;
                result = e;
                break;
            }
            if (result == null) {
                throw new IllegalArgumentException("cannot map " + wait + " to a error accessory state");
            }
            return result;
        }
    }
}

