/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.utils;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.bidib.jbidibc.messages.utils.StringUtils;

public final class ByteUtils {
    public static final byte MAGIC = ByteUtils.getLowByte(254);
    public static final byte ESCAPE = ByteUtils.getLowByte(253);
    public static final char[] HEXARRAY = "0123456789ABCDEF".toCharArray();

    private ByteUtils() {
    }

    public static byte[] toDWORD(int value) {
        byte[] dword = new byte[4];
        for (int index = 0; index < 4; ++index) {
            byte val;
            dword[index] = val = (byte)(value >> 8 * index & 0xFF);
        }
        return dword;
    }

    public static byte[] toDWORD(long value) {
        byte[] dword = new byte[4];
        for (int index = 0; index < 4; ++index) {
            byte val;
            dword[index] = val = (byte)(value >> 8 * index & 0xFFL);
        }
        return dword;
    }

    public static long getDWORD(byte[] value) {
        long dword = 0L;
        for (int index = 3; index > -1; --index) {
            dword = dword << 8 | (long)(value[index] & 0xFF);
        }
        return dword;
    }

    public static long getDWORD(byte[] data, int offset) {
        long dword = 0L;
        for (int index = 3 + offset; index > offset - 1; --index) {
            dword = dword << 8 | (long)(data[index] & 0xFF);
        }
        return dword;
    }

    public static byte[] toWORD(int value) {
        byte[] word = new byte[2];
        for (int index = 0; index < 2; ++index) {
            byte val;
            word[index] = val = (byte)(value >> 8 * index & 0xFF);
        }
        return word;
    }

    public static int getWORD(byte[] value) {
        int word = 0;
        for (int index = 1; index > -1; --index) {
            word = word << 8 | value[index] & 0xFF;
        }
        return word;
    }

    public static int getWORD(byte[] data, int offset) {
        int word = 0;
        for (int index = 1 + offset; index > offset - 1; --index) {
            word = word << 8 | data[index] & 0xFF;
        }
        return word;
    }

    public static int getWORDbigEndian(byte[] data, int offset) {
        int word = 0;
        for (int index = offset; index < offset + 2; ++index) {
            word = word << 8 | data[index] & 0xFF;
        }
        return word;
    }

    public static int getWORD(int value) {
        return value & 0xFFFF;
    }

    public static int getWord(byte lowByte, byte highByte) {
        return ((highByte & 0x3F) << 8) + (lowByte & 0xFF);
    }

    public static byte[] int32ToByteArrayBigEndian(int value) {
        byte[] data = new byte[4];
        data[3] = (byte)((value & 0xFF000000) >>> 24 & 0xFF);
        data[2] = (byte)((value & 0xFF0000) >>> 16 & 0xFF);
        data[1] = (byte)((value & 0xFF00) >>> 8 & 0xFF);
        data[0] = (byte)(value & 0xFF & 0xFF);
        return data;
    }

    public static int getInt(byte lowByte, byte highByte) {
        return ((highByte & 0xFF) << 8) + (lowByte & 0xFF);
    }

    public static Integer getInteger(Byte lowByte, Byte highByte) {
        if (lowByte != null && highByte != null) {
            return ((highByte & 0xFF) << 8) + (lowByte & 0xFF);
        }
        return null;
    }

    public static Integer getInteger(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static int getInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static int getInt(byte byteValue, int mask) {
        return byteValue & mask;
    }

    public static int getInt(int intValue, int mask) {
        return intValue & mask;
    }

    public static Integer getInteger(Integer value, int mask) {
        if (value != null) {
            return value & mask;
        }
        return null;
    }

    public static int getInt(byte[] data, int index) {
        return ByteUtils.getInt(data[index]);
    }

    public static Integer getRGB(Integer value) {
        if (value == null) {
            return null;
        }
        return value & 0xFFFFFF;
    }

    public static int getRGB(byte[] value) {
        int dword = 0;
        for (int index = 0; index < 3; ++index) {
            dword = dword << 8 | value[index] & 0xFF;
        }
        return dword;
    }

    public static byte[] toRGB(int value) {
        byte[] dword = new byte[3];
        int targetIndex = 0;
        for (int index = 0; index < 3; ++index) {
            byte val;
            dword[targetIndex] = val = (byte)(value >> 8 * (2 - index) & 0xFF);
            ++targetIndex;
        }
        return dword;
    }

    public static int getReconfig(byte[] value) {
        int dword = 0;
        for (int index = 3; index > 0; --index) {
            dword = dword << 8 | value[index - 1] & 0xFF;
        }
        return dword;
    }

    public static byte[] toReconfig(int value) {
        byte[] dword = new byte[3];
        int targetIndex = 2;
        for (int index = 3; index > 0; --index) {
            byte val;
            dword[targetIndex] = val = (byte)(value >> 8 * (index - 1) & 0xFF);
            --targetIndex;
        }
        return dword;
    }

    public static int getCvXNumber(byte[] data, int offset) {
        int dword = 0;
        for (int index = 3 + offset; index > offset; --index) {
            dword = dword << 8 | data[index - 1] & 0xFF;
        }
        return dword;
    }

    public static int getCvXValue(byte[] data, int offset, int count) {
        if (count < 1 || count > 4) {
            throw new IllegalArgumentException("Allowed count values: 1..4");
        }
        int dword = 0;
        for (int index = count + offset; index > offset; --index) {
            dword = dword << 8 | data[index - 1] & 0xFF;
        }
        return dword;
    }

    public static byte[] concat(byte[] array1, byte[] array2) {
        byte[] result = new byte[array1.length + (array2 != null ? array2.length : 0)];
        System.arraycopy(array1, 0, result, 0, array1.length);
        if (array2 != null) {
            System.arraycopy(array2, 0, result, array1.length, array2.length);
        }
        return result;
    }

    public static byte[] append(byte[] array1, byte value) {
        byte[] result = new byte[array1.length + 1];
        System.arraycopy(array1, 0, result, 0, array1.length);
        result[array1.length] = value;
        return result;
    }

    public static byte[] prepend(byte value, byte[] array1) {
        if (array1 == null) {
            return new byte[]{value};
        }
        byte[] result = new byte[array1.length + 1];
        result[0] = value;
        System.arraycopy(array1, 0, result, 1, array1.length);
        return result;
    }

    public static byte[] append(byte[] array1, int value) {
        byte[] result = new byte[array1.length + 2];
        System.arraycopy(array1, 0, result, 0, array1.length);
        result[array1.length] = ByteUtils.getLowByte(value);
        result[array1.length + 1] = ByteUtils.getHighByte(value);
        return result;
    }

    public static byte[] prepend(byte[] array1, int value) {
        byte[] result = new byte[array1.length + 2];
        result[0] = ByteUtils.getLowByte(value);
        result[1] = ByteUtils.getHighByte(value);
        System.arraycopy(array1, 0, result, 2, array1.length);
        return result;
    }

    public static byte[] toArray(byte ... element) {
        return element;
    }

    public static byte[] toArray(int[] elements) {
        byte[] result = new byte[elements.length];
        int index = 0;
        for (int element : elements) {
            result[index] = ByteUtils.getLowByte(element);
            ++index;
        }
        return result;
    }

    public static byte[] subArray(byte[] data, int offset) {
        byte[] result = new byte[data.length - offset];
        System.arraycopy(data, offset, result, 0, result.length);
        return result;
    }

    public static byte[] subArray(byte[] data, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(data, offset, result, 0, result.length);
        return result;
    }

    public static byte[] convertLongToUniqueId(Long uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        byte[] value = BigInteger.valueOf(uniqueId).toByteArray();
        byte[] uniqueIdArray = new byte[7];
        int len = value.length > 7 ? 7 : value.length;
        System.arraycopy(value, value.length - len, uniqueIdArray, 7 - len, len);
        return uniqueIdArray;
    }

    public static byte[] convertLongToUniqueId(long uniqueId) {
        byte[] value = BigInteger.valueOf(uniqueId).toByteArray();
        byte[] uniqueIdArray = new byte[7];
        int len = value.length > 7 ? 7 : value.length;
        System.arraycopy(value, value.length - len, uniqueIdArray, 7 - len, len);
        return uniqueIdArray;
    }

    public static byte[] getVidPidFromUniqueId(long uniqueId) {
        byte[] value = BigInteger.valueOf(uniqueId).toByteArray();
        byte[] uniqueIdArray = new byte[7];
        int len = value.length > 7 ? 7 : value.length;
        System.arraycopy(value, value.length - len, uniqueIdArray, 7 - len, len);
        return uniqueIdArray;
    }

    public static int getClassIdFromUniqueId(long uniqueId) {
        byte[] uniqueIdArray = ByteUtils.convertLongToUniqueId(uniqueId);
        return ByteUtils.getInt(uniqueIdArray[0]);
    }

    public static long convertUniqueIdToLong(byte[] uniqueId) {
        long result = 0L;
        for (int i = 0; i < uniqueId.length; ++i) {
            result = (result << 8) + (long)(uniqueId[i] & 0xFF);
        }
        return result;
    }

    public static String convertUniqueIdToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append('.');
        }
        return r.substring(0, r.length() - 1);
    }

    public static byte[] getUniqueId(long uniqueId) {
        byte[] result = new byte[7];
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(uniqueId);
        System.arraycopy(bb.array(), 1, result, 0, result.length);
        return result;
    }

    public static long getUniqueId(byte[] uniqueId) {
        long result = 0L;
        for (int i = 0; i < uniqueId.length; ++i) {
            result = (result << 8) + (long)(uniqueId[i] & 0xFF);
        }
        return result;
    }

    public static String formatHexUniqueId(long uniqueId) {
        return String.format("0x%014X", uniqueId & 0xFFFFFFFFFFFFFFL);
    }

    public static String formatHexUniqueId(Long uniqueId) {
        if (uniqueId != null) {
            return String.format("0x%014X", uniqueId & 0xFFFFFFFFFFFFFFL);
        }
        return null;
    }

    public static Long parseHexUniqueId(String uniqueId) {
        if (StringUtils.isNotBlank(uniqueId)) {
            if (uniqueId.startsWith("0x")) {
                return Long.parseLong(uniqueId.substring(2), 16) & 0xFFFFFFFFFFFFFFL;
            }
            return Long.parseLong(uniqueId, 16) & 0xFFFFFFFFFFFFFFL;
        }
        return null;
    }

    public static String getUniqueIdAsString(long uniqueId) {
        return String.format("V %02X P %08X", uniqueId >> 32 & 0xFFL, uniqueId & 0xFFFFFFFFL);
    }

    public static String getUniqueIdAsString(Long uniqueId) {
        if (uniqueId != null) {
            return String.format("V %02X P %08X", uniqueId >> 32 & 0xFFL, uniqueId & 0xFFFFFFFFL);
        }
        return null;
    }

    public static String getUniqueIdAsStringCompact(long uniqueId) {
        return String.format("V%02XP%08X", uniqueId >> 32 & 0xFFL, uniqueId & 0xFFFFFFFFL);
    }

    public static String getUniqueIdAsStringCompact(Long uniqueId) {
        if (uniqueId != null) {
            return String.format("V%02XP%08X", uniqueId >> 32 & 0xFFL, uniqueId & 0xFFFFFFFFL);
        }
        return null;
    }

    public static String toString(byte[] bytes) {
        StringBuilder result = new StringBuilder("[");
        if (bytes != null) {
            for (byte b : bytes) {
                if (result.length() > 1) {
                    result.append(", ");
                }
                result.append(b & 0xFF);
            }
        }
        result.append("]");
        return result.toString();
    }

    public static String toString(byte bValue) {
        return Integer.toString(bValue & 0xFF);
    }

    public static boolean arrayEquals(byte[] a1, byte[] a2) {
        return Arrays.equals(a1, a2);
    }

    public static byte getLowByte(int value) {
        byte lowByte = ByteUtils.getLowByte(value, 255);
        return lowByte;
    }

    public static byte getLowByte(int value, int mask) {
        byte lowByte = (byte)(value & mask);
        return lowByte;
    }

    public static Byte getLowByte(Integer value) {
        if (value != null) {
            byte lowByte = (byte)(value & 0xFF);
            return lowByte;
        }
        return null;
    }

    public static byte getHighByte(int value) {
        byte penultimateByte = (byte)(value >> 8 & 0xFF);
        return penultimateByte;
    }

    public static byte getHighByte(int value, int mask) {
        byte penultimateByte = (byte)(value >> 8 & mask);
        return penultimateByte;
    }

    public static int getLowNibble(byte value) {
        int lowNibble = value & 0xF;
        return lowNibble;
    }

    public static int getHighNibble(byte value) {
        int highNibble = (value & 0xF0) >> 4;
        return highNibble;
    }

    public static int toInt(int highByte, int lowByte) {
        int ret = (highByte & 0xFF) << 8 | lowByte & 0xFF;
        return ret;
    }

    public static byte getHighWordLowByte(int value) {
        byte penultimateByte = (byte)(value >> 16 & 0xFF);
        return penultimateByte;
    }

    public static byte getHighWordHighByte(int value) {
        byte penultimateByte = (byte)(value >> 24 & 0xFF);
        return penultimateByte;
    }

    public static Byte getHighByte(Integer value) {
        if (value != null) {
            byte penultimateByte = (byte)(value >> 8 & 0xFF);
            return penultimateByte;
        }
        return null;
    }

    public static int getIntLowByteValue(int value) {
        return value & 0xFF;
    }

    public static int getIntHighByteValue(int value) {
        return (value & 0xFF00) >> 8;
    }

    public static int convertSerial(byte[] serialData, int offset) {
        int result = 0;
        if (serialData != null) {
            for (int index = 0; index < 4; ++index) {
                result += (serialData[index + offset] & 0xFF) << index * 8;
            }
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        return ByteUtils.bytesToHex(bytes, true);
    }

    public static String bytesToHex(byte[] bytes, boolean addSeparator) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            if (!addSeparator) continue;
            r.append(' ');
        }
        return r.substring(0, r.length() - 1);
    }

    public static String bytesToHex(byte[] bytes, char separator) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append(separator);
        }
        return r.substring(0, r.length() - 1);
    }

    public static String bytesToHex(ByteArrayOutputStream bytes) {
        if (bytes == null || bytes.size() == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.size() * 3);
        for (byte b : bytes.toByteArray()) {
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append(' ');
        }
        return r.substring(0, r.length() - 1);
    }

    public static String bytesToHex(int[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 3);
        for (int i : bytes) {
            byte b = ByteUtils.getLowByte(i);
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append(' ');
        }
        return r.substring(0, r.length() - 1);
    }

    public static String bytesToHex(byte[] bytes, int length) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(length * 3);
        for (int index = 0; index < length; ++index) {
            byte b = bytes[index];
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append(' ');
        }
        return r.substring(0, r.length() - 1);
    }

    public static String bytesToHex(int[] bytes, int length) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(length * 3);
        for (int index = 0; index < length; ++index) {
            byte b = ByteUtils.getLowByte(bytes[index]);
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            r.append(' ');
        }
        return r.substring(0, r.length() - 1);
    }

    public static String int16ToHex(int byteValue) {
        char[] hexChars = new char[]{HEXARRAY[(byteValue & 0xF000) >>> 12], HEXARRAY[(byteValue & 0xF00) >>> 8], HEXARRAY[(byteValue & 0xF0) >>> 4], HEXARRAY[byteValue & 0xF]};
        return new String(hexChars);
    }

    public static String int32ToHex(long byteValue) {
        char[] hexChars = new char[]{HEXARRAY[((int)byteValue & 0xF0000000) >>> 28], HEXARRAY[((int)byteValue & 0xF000000) >>> 24], HEXARRAY[((int)byteValue & 0xF00000) >>> 20], HEXARRAY[((int)byteValue & 0xF0000) >>> 16], HEXARRAY[((int)byteValue & 0xF000) >>> 12], HEXARRAY[((int)byteValue & 0xF00) >>> 8], HEXARRAY[((int)byteValue & 0xF0) >>> 4], HEXARRAY[(int)byteValue & 0xF]};
        return new String(hexChars);
    }

    public static String int32ToHex(int byteValue) {
        char[] hexChars = new char[]{HEXARRAY[(byteValue & 0xF0000000) >>> 28], HEXARRAY[(byteValue & 0xF000000) >>> 24], HEXARRAY[(byteValue & 0xF00000) >>> 20], HEXARRAY[(byteValue & 0xF0000) >>> 16], HEXARRAY[(byteValue & 0xF000) >>> 12], HEXARRAY[(byteValue & 0xF00) >>> 8], HEXARRAY[(byteValue & 0xF0) >>> 4], HEXARRAY[byteValue & 0xF]};
        return new String(hexChars);
    }

    public static String rgbToHex(int byteValue) {
        char[] hexChars = new char[]{HEXARRAY[(byteValue & 0xF00000) >>> 20], HEXARRAY[(byteValue & 0xF0000) >>> 16], HEXARRAY[(byteValue & 0xF000) >>> 12], HEXARRAY[(byteValue & 0xF00) >>> 8], HEXARRAY[(byteValue & 0xF0) >>> 4], HEXARRAY[byteValue & 0xF]};
        return new String(hexChars);
    }

    public static String rgbToHex(Integer byteValue) {
        if (byteValue != null) {
            char[] hexChars = new char[]{HEXARRAY[(byteValue & 0xF00000) >>> 20], HEXARRAY[(byteValue & 0xF0000) >>> 16], HEXARRAY[(byteValue & 0xF000) >>> 12], HEXARRAY[(byteValue & 0xF00) >>> 8], HEXARRAY[(byteValue & 0xF0) >>> 4], HEXARRAY[byteValue & 0xF]};
            return new String(hexChars);
        }
        return null;
    }

    public static String magicToHex(int magic) {
        char[] hexChars = new char[]{HEXARRAY[(magic & 0xF000) >>> 12], HEXARRAY[(magic & 0xF00) >>> 8], HEXARRAY[(magic & 0xF0) >>> 4], HEXARRAY[magic & 0xF]};
        return new String(hexChars);
    }

    public static String magicToHex(Integer magic) {
        if (magic == null) {
            return null;
        }
        char[] hexChars = new char[]{HEXARRAY[(magic & 0xF000) >>> 12], HEXARRAY[(magic & 0xF00) >>> 8], HEXARRAY[(magic & 0xF0) >>> 4], HEXARRAY[magic & 0xF]};
        return new String(hexChars);
    }

    public static String byteToHex(Byte byteValue) {
        if (byteValue != null) {
            return ByteUtils.byteToHex((byte)byteValue);
        }
        return null;
    }

    public static String byteToHex(byte byteValue) {
        char[] hexChars = new char[2];
        int v = byteValue & 0xFF;
        hexChars[0] = HEXARRAY[v >>> 4];
        hexChars[1] = HEXARRAY[v & 0xF];
        return new String(hexChars);
    }

    public static String byteToHex(int byteValue) {
        char[] hexChars = new char[2];
        int v = byteValue & 0xFF;
        hexChars[0] = HEXARRAY[v >>> 4];
        hexChars[1] = HEXARRAY[v & 0xF];
        return new String(hexChars);
    }

    public static String longToHex(long value) {
        char[] hexChars = new char[]{HEXARRAY[(int)((value & 0xF0000000L) >>> 28)], HEXARRAY[(int)((value & 0xF000000L) >>> 24)], HEXARRAY[(int)((value & 0xF00000L) >>> 20)], HEXARRAY[(int)((value & 0xF0000L) >>> 16)], HEXARRAY[(int)((value & 0xF000L) >>> 12)], HEXARRAY[(int)((value & 0xF00L) >>> 8)], HEXARRAY[(int)((value & 0xF0L) >>> 4)], HEXARRAY[(int)value & 0xF]};
        return new String(hexChars);
    }

    public static String intToHex(int value) {
        char[] hexChars = new char[]{HEXARRAY[(value & 0xF000) >>> 12], HEXARRAY[(value & 0xF00) >>> 8], HEXARRAY[(value & 0xF0) >>> 4], HEXARRAY[value & 0xF]};
        return new String(hexChars);
    }

    public static String intToHexBigEndian(int value) {
        char[] hexChars = new char[]{HEXARRAY[(value & 0xF0) >>> 4], HEXARRAY[value & 0xF], HEXARRAY[(value & 0xF000) >>> 12], HEXARRAY[(value & 0xF00) >>> 8]};
        return new String(hexChars);
    }

    public static String integerToHex(Integer value) {
        if (value == null) {
            return null;
        }
        char[] hexChars = new char[]{HEXARRAY[(value & 0xF000) >>> 12], HEXARRAY[(value & 0xF00) >>> 8], HEXARRAY[(value & 0xF0) >>> 4], HEXARRAY[value & 0xF]};
        return new String(hexChars);
    }

    public static byte[] parseHexBinary(String hexString) {
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("The hexBinary needs to be even-length. Current len: " + len + " => " + hexString);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = ByteUtils.hexToBin(hexString.charAt(i));
            int l = ByteUtils.hexToBin(hexString.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + hexString);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    public static byte[] parseHexBinarySpaceTerminated(String hexString) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StringTokenizer tokenizer = new StringTokenizer(hexString, " ");
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            int h = ByteUtils.hexToBin(tok.charAt(0));
            int l = ByteUtils.hexToBin(tok.charAt(1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + hexString);
            }
            os.write((byte)(h * 16 + l));
        }
        return os.toByteArray();
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static byte setBit(byte byteValue, boolean bit, int bitpos) {
        int intValue = byteValue & 0xFF;
        int newValue = bit ? intValue | 1 << bitpos : intValue & ~(1 << bitpos);
        return ByteUtils.getLowByte(newValue);
    }

    public static byte setBit(int byteValue, boolean bit, int bitpos) {
        int intValue = byteValue & 0xFF;
        int newValue = bit ? intValue | 1 << bitpos : intValue & ~(1 << bitpos);
        return ByteUtils.getLowByte(newValue);
    }

    public static int getBit(byte byteValue, int bitpos) {
        int intValue = byteValue & 0xFF;
        return intValue >>> bitpos & 1;
    }

    public static int getBit(int intValue, int bitpos) {
        return intValue >>> bitpos & 1;
    }

    public static boolean isBitSetEqual(byte byteValue, int bit, int bitpos) {
        int intValue = byteValue & 0xFF;
        return (intValue >>> bitpos & 1) == bit;
    }

    public static boolean isBitSetEqual(int intValue, int bit, int bitpos) {
        return (intValue >>> bitpos & 1) == bit;
    }

    public static byte[] bstr(String value) {
        byte[] valueBytes = value.getBytes(StandardCharsets.ISO_8859_1);
        if (valueBytes.length > 255) {
            throw new IllegalArgumentException("Maximum string length of 255 exceeded.");
        }
        byte[] result = new byte[valueBytes.length + 1];
        result[0] = ByteUtils.getLowByte(valueBytes.length);
        System.arraycopy(valueBytes, 0, result, 1, valueBytes.length);
        return result;
    }

    public static byte[] bstr(String name, String value) {
        byte[] nameBytes = name.getBytes(StandardCharsets.ISO_8859_1);
        byte[] valueBytes = value.getBytes(StandardCharsets.ISO_8859_1);
        if (nameBytes.length > 255 || valueBytes.length > 255) {
            throw new IllegalArgumentException("Maximum string length of 255 exceeded.");
        }
        byte[] result = new byte[nameBytes.length + valueBytes.length + 2];
        result[0] = ByteUtils.getLowByte(nameBytes.length);
        System.arraycopy(nameBytes, 0, result, 1, nameBytes.length);
        result[nameBytes.length + 1] = ByteUtils.getLowByte(valueBytes.length);
        System.arraycopy(valueBytes, 0, result, nameBytes.length + 2, valueBytes.length);
        return result;
    }

    public static String cstr(byte[] bstr, int offset) {
        int length = bstr[offset];
        if (length > bstr.length - offset - 1) {
            length = bstr.length - offset - 1;
        }
        byte[] cstr = new byte[length];
        if (length > 0) {
            System.arraycopy(bstr, offset + 1, cstr, 0, length);
            return new String(cstr, StandardCharsets.ISO_8859_1);
        }
        return "";
    }

    public static String cstrUTF8(byte[] bstr, int offset) {
        int length = bstr[offset];
        if (length > bstr.length - offset - 1) {
            length = bstr.length - offset - 1;
        }
        byte[] cstr = new byte[length];
        if (length > 0) {
            System.arraycopy(bstr, offset + 1, cstr, 0, length);
            return new String(cstr, StandardCharsets.UTF_8);
        }
        return "";
    }

    public static String getString(byte[] bstr, int offset, int length) {
        byte[] cstr = new byte[length];
        if (length > 0) {
            System.arraycopy(bstr, offset, cstr, 0, length);
            return new String(cstr, StandardCharsets.ISO_8859_1);
        }
        return "";
    }

    public static String getString(byte[] bstr) {
        int offset = 0;
        int length = bstr.length;
        return ByteUtils.getString(bstr, offset, length);
    }

    public static String getString(byte[] bstr, int offset) {
        int length = bstr.length - offset;
        return ByteUtils.getString(bstr, offset, length);
    }

    public static byte[] toByteArray(String value) {
        byte[] valueBytes = value.getBytes(StandardCharsets.ISO_8859_1);
        return valueBytes;
    }

    public static byte[] toByteArray(String value, Charset charset) {
        byte[] valueBytes = value.getBytes(charset);
        return valueBytes;
    }

    public static String getStringTerminatedbyZero(byte[] data, int offset) {
        if (data.length - offset > 0) {
            int end;
            for (end = offset; end < data.length && data[end] != 0; ++end) {
            }
            byte[] cstr = new byte[end - offset];
            System.arraycopy(data, offset, cstr, 0, cstr.length);
            return new String(cstr, StandardCharsets.ISO_8859_1);
        }
        return "";
    }

    public static String didToHex(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 2 + 1);
        int len = bytes.length;
        for (int index = len - 1; index > -1; --index) {
            byte b = bytes[index];
            r.append(HEXARRAY[b >> 4 & 0xF]);
            r.append(HEXARRAY[b & 0xF]);
            if (index != len - 1) continue;
            r.append(' ');
        }
        return r.substring(0, r.length());
    }

    public static int getMaskedAndShiftedValue(int source, int mask) {
        while ((mask & 1) == 0) {
            source >>= 1;
            mask >>= 1;
        }
        return source;
    }

    public static int getMaskedValue(int source, int mask) {
        return source & mask;
    }
}

