/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.utils;

import java.util.BitSet;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public final class ConversionUtils {
    public static int convertCurrent(int current) {
        if (current > 15) {
            current = current >= 16 && current <= 63 ? (current - 12) * 4 : (current >= 64 && current <= 127 ? (current - 51) * 16 : (current >= 128 && current <= 191 ? (current - 108) * 64 : (current >= 192 && current <= 250 ? (current - 171) * 256 : 0)));
        }
        return current;
    }

    public static int encodeCurrent(int current) {
        if (current > 15) {
            if (current >= 5376 && current <= 20224) {
                current = current / 256 + 171;
            } else if (current >= 1280 && current <= 5312) {
                current = current / 64 + 108;
            } else if (current >= 208 && current <= 1216) {
                current = current / 16 + 51;
            } else if (current >= 16 && current <= 204) {
                current = current / 4 + 12;
            }
        }
        return current;
    }

    public static int convertVoltageValue(int value) {
        int result = 0;
        if (value >= 0 && value <= 250) {
            result = value;
        }
        return result;
    }

    public static int encodeVoltage(int voltage) {
        if (voltage < 0 || voltage > 250) {
            voltage = 255;
        }
        return voltage;
    }

    public static int convertTemperatureValue(int value) {
        int result = 0;
        if (value >= 0 && value <= 127) {
            result = value;
        } else if (value >= 226 && value <= 255) {
            result = value - 255;
        }
        return result;
    }

    public static int encodeTemperature(int temperature) {
        if (temperature < 0 || temperature <= 127) {
            // empty if block
        }
        return temperature;
    }

    public static int convertSpeed(int speed) {
        DirectionEnum direction;
        int result = 0;
        DirectionEnum directionEnum = direction = speed > 0 ? DirectionEnum.FORWARD : DirectionEnum.BACKWARD;
        result = speed == 0 ? speed : (speed > 0 ? speed + 1 : (speed = -(speed - 1)));
        result &= 0x7F;
        if (direction == DirectionEnum.FORWARD) {
            result |= 0x80;
        }
        return result;
    }

    public static byte convertSpeed(Integer speed, DirectionEnum direction) {
        byte result = 0;
        if (speed != null) {
            result = ByteUtils.getLowByte(speed);
        }
        if (direction == DirectionEnum.FORWARD) {
            result = (byte)(result | 0x80);
        }
        return result;
    }

    public static int bidibSpeedToDccSpeed(int bidibSpeed, SpeedStepsEnum speedSteps) {
        int speed = bidibSpeed;
        switch (speedSteps) {
            case DCC28: {
                if (bidibSpeed == 1) {
                    speed = -1;
                    break;
                }
                if (bidibSpeed <= 1) break;
                speed = (bidibSpeed - 2) * 2 / 9 + 2;
                --speed;
                break;
            }
            case DCC14: {
                if (bidibSpeed == 1) {
                    speed = -1;
                    break;
                }
                if (bidibSpeed <= 1) break;
                speed = (bidibSpeed - 2) / 9 + 2;
                --speed;
                break;
            }
        }
        return speed;
    }

    public static byte[] convertFunctions(BitSet bits) {
        byte[] result = new byte[4];
        if (bits != null) {
            for (int bitIndex = 0; bitIndex < bits.length(); ++bitIndex) {
                if (bitIndex == 0) {
                    result[0] = (byte)(result[0] | ConversionUtils.convert(bits.get(bitIndex)) << 4);
                    continue;
                }
                if (bitIndex < 5) {
                    result[0] = (byte)(result[0] | ConversionUtils.convert(bits.get(bitIndex)) << bitIndex - 1);
                    continue;
                }
                if (bitIndex < 13) {
                    result[1] = (byte)(result[1] | ConversionUtils.convert(bits.get(bitIndex)) << bitIndex - 5);
                    continue;
                }
                if (bitIndex < 21) {
                    result[2] = (byte)(result[2] | ConversionUtils.convert(bits.get(bitIndex)) << bitIndex - 13);
                    continue;
                }
                result[3] = (byte)(result[3] | ConversionUtils.convert(bits.get(bitIndex)) << bitIndex - 21);
            }
        }
        return result;
    }

    private static byte convert(boolean value) {
        return value ? (byte)1 : 0;
    }

    public static BitSet convertFunctions(int[] functions) {
        byte[] functionsBytes = new byte[4];
        for (int index = 0; index < functionsBytes.length; ++index) {
            functionsBytes[index] = ByteUtils.getLowByte(functions[index]);
        }
        return ConversionUtils.convertFunctions(functionsBytes);
    }

    public static BitSet convertFunctions(byte[] functions) {
        int numBits = 29;
        BitSet functionBits = new BitSet(numBits);
        if (functions != null) {
            for (int bitIndex = 0; bitIndex < numBits; ++bitIndex) {
                if (bitIndex == 0) {
                    functionBits.set(0, ByteUtils.getBit(functions[0], 4) == 1);
                    continue;
                }
                if (bitIndex < 5) {
                    functionBits.set(bitIndex, ByteUtils.getBit(functions[0], bitIndex - 1) == 1);
                    continue;
                }
                if (bitIndex < 13) {
                    functionBits.set(bitIndex, ByteUtils.getBit(functions[1], bitIndex - 5) == 1);
                    continue;
                }
                if (bitIndex < 21) {
                    functionBits.set(bitIndex, ByteUtils.getBit(functions[2], bitIndex - 13) == 1);
                    continue;
                }
                functionBits.set(bitIndex, ByteUtils.getBit(functions[3], bitIndex - 21) == 1);
            }
        }
        return functionBits;
    }

    public static byte getOutputFunctionBits(Integer speed, BitSet activeFunctions) {
        byte result = 0;
        if (speed != null) {
            result = (byte)(result | 1);
        }
        if (activeFunctions != null) {
            if (activeFunctions.get(0)) {
                result = (byte)(result | 2);
            }
            if (activeFunctions.get(1)) {
                result = (byte)(result | 4);
            }
            if (activeFunctions.get(2)) {
                result = (byte)(result | 8);
            }
            if (activeFunctions.get(3)) {
                result = (byte)(result | 0x10);
            }
            if (activeFunctions.get(4)) {
                result = (byte)(result | 0x20);
            }
        }
        return result;
    }
}

