/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.bidib.jbidibc.messages.CRC8;
import org.bidib.jbidibc.messages.MessageConsumer;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;

public class MessageUtils {
    public static void splitBidibMessages(Logger logger, ByteArrayOutputStream outputStream, boolean checkCRC, AtomicBoolean isFirstPacket, MessageConsumer messageConsumer) throws ProtocolException {
        try {
            MessageUtils.splitBidibMessages(logger, outputStream, checkCRC, messageConsumer, isFirstPacket);
        }
        catch (ProtocolException ex) {
            if (logger != null) {
                logger.warn("Split bidib messages failed: {}", ex.getMessage());
            }
            if (isFirstPacket.get()) {
                byte[] output = outputStream.toByteArray();
                for (int index = 0; index < output.length; ++index) {
                    ByteArrayOutputStream outputStream2;
                    block11: {
                        byte[] output2;
                        block10: {
                            if (ByteUtils.MAGIC != output[index]) continue;
                            output2 = ByteUtils.subArray(output, index + 1);
                            if (logger != null) {
                                logger.info("Prepare new data to split: {}", ByteUtils.bytesToHex(output2));
                            }
                            try {
                                outputStream.reset();
                                outputStream.write(output2);
                            }
                            catch (IOException ex1) {
                                if (logger == null) break block10;
                                logger.warn("Write data after magic to output stream failed.", ex1);
                            }
                        }
                        outputStream2 = new ByteArrayOutputStream();
                        try {
                            outputStream2.write(output2);
                        }
                        catch (IOException ex2) {
                            if (logger == null) break block11;
                            logger.warn("Write data to output stream failed.", ex2);
                        }
                    }
                    MessageUtils.splitBidibMessages(logger, outputStream2, checkCRC, messageConsumer, isFirstPacket);
                }
            }
            throw ex;
        }
        outputStream.reset();
    }

    public static void splitBidibMessages(Logger logger, ByteArrayOutputStream outputStream, boolean checkCRC, MessageConsumer messageConsumer, AtomicBoolean isFirstPacket) throws ProtocolException {
        int index = 0;
        byte[] output = outputStream.toByteArray();
        while (index < output.length) {
            int crcIndex;
            int size = ByteUtils.getInt(output[index]) + 1;
            if (size <= 0) {
                throw new ProtocolException("cannot split messages, array size is " + size);
            }
            byte[] message = new byte[size];
            try {
                System.arraycopy(output, index, message, 0, message.length);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                StringBuilder sb = new StringBuilder("Copy message data to buffer failed. Current msg.len: ");
                sb.append(message.length).append(", size: ").append(size).append(", output.len: ").append(output.length);
                sb.append(", index: ").append(index).append(", output: ").append(ByteUtils.bytesToHex(output));
                outputStream.reset();
                outputStream.write(output, index, output.length - index);
                if (logger != null) {
                    logger.info("Keep the remaining data in the outputStream: {}", ByteUtils.bytesToHex(outputStream));
                }
                throw new ProtocolException(sb.toString());
            }
            isFirstPacket.set(false);
            messageConsumer.accept(message);
            if (!checkCRC || (index += size) != output.length - 1) continue;
            int crc = 0;
            for (crcIndex = 0; crcIndex < output.length - 1; ++crcIndex) {
                crc = CRC8.getCrcValue((output[crcIndex] ^ crc) & 0xFF);
            }
            if (crc != (output[crcIndex] & 0xFF)) {
                throw new ProtocolException("CRC failed: should be " + crc + " but was " + (output[crcIndex] & 0xFF));
            }
            ++index;
        }
    }

    public static String formatNodeAddressAndName(Node node) {
        StringBuilder nodeIdentifier = new StringBuilder();
        nodeIdentifier.append(ByteUtils.getUniqueIdAsString(node.getUniqueId()));
        nodeIdentifier.append(", address: ").append(NodeUtils.formatAddressLong(node.getAddr()));
        String nodeName = node.getStoredString(1);
        if (StringUtils.isBlank(nodeName)) {
            nodeIdentifier.append(", product name: ").append(node.getStoredString(0));
        } else {
            nodeIdentifier.append(", name: ").append(nodeName);
        }
        return nodeIdentifier.toString();
    }

    public static String formatSysError(Node node, Function<byte[], Node> nodeFinder, SysErrorEnum sysErrorEnum, byte[] reasonData) {
        StringBuilder sb = new StringBuilder();
        if (sysErrorEnum != null) {
            byte[] addr = node.getAddr();
            String nodeIdentifier = MessageUtils.formatNodeAddressAndName(node);
            MessageUtils.formatSysError(sb, nodeIdentifier, addr, nodeFinder, sysErrorEnum, reasonData);
        }
        return sb.toString();
    }

    public static String formatSysError(byte[] addr, Function<byte[], Node> nodeFinder, SysErrorEnum sysErrorEnum, byte[] reasonData) {
        StringBuilder sb = new StringBuilder();
        if (sysErrorEnum != null) {
            String nodeIdentifier = NodeUtils.formatAddressLong(addr);
            MessageUtils.formatSysError(sb, nodeIdentifier, addr, nodeFinder, sysErrorEnum, reasonData);
        }
        return sb.toString();
    }

    protected static void formatSysError(StringBuilder sb, String nodeIdentifier, byte[] addr, Function<byte[], Node> nodeFinder, SysErrorEnum sysErrorEnum, byte[] reasonData) {
        try {
            switch (sysErrorEnum) {
                case BIDIB_ERR_NONE: {
                    sb.append("BIDIB_ERR_NONE for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                    break;
                }
                case BIDIB_ERR_TXT: {
                    sb.append("BIDIB_ERR_TXT for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), text len: ").append(ByteUtils.getInt(reasonData[0])).append(", text: ").append(new String(reasonData, StandardCharsets.UTF_8));
                    break;
                }
                case BIDIB_ERR_CRC: {
                    sb.append("BIDIB_ERR_CRC for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), sequence num of invalid message: ").append(ByteUtils.getInt(reasonData[0]));
                    break;
                }
                case BIDIB_ERR_SIZE: {
                    sb.append("BIDIB_ERR_SIZE for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), sequence num of invalid message: ").append(ByteUtils.getInt(reasonData[0]));
                    break;
                }
                case BIDIB_ERR_SEQUENCE: {
                    sb.append("BIDIB_ERR_SEQUENCE for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                    if (reasonData.length > 3) {
                        sb.append(", expected sequence: ").append(ByteUtils.getInt(reasonData[0]));
                        sb.append(", received sequence: ").append(ByteUtils.getInt(reasonData[1]));
                        sb.append(", crc_errs: ").append(ByteUtils.getInt(reasonData[2]));
                        sb.append(", hw_errs: ").append(ByteUtils.getInt(reasonData[3]));
                        break;
                    }
                    if (reasonData.length > 1) {
                        sb.append(", expected sequence: ").append(ByteUtils.getInt(reasonData[0]));
                        sb.append(", received sequence: ").append(ByteUtils.getInt(reasonData[1]));
                        break;
                    }
                    sb.append(", last correct sequence: ").append(ByteUtils.getInt(reasonData[0]));
                    break;
                }
                case BIDIB_ERR_PARAMETER: {
                    sb.append("BIDIB_ERR_PARAMETER for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), sequence num of invalid message: ").append(ByteUtils.getInt(reasonData[0]));
                    break;
                }
                case BIDIB_ERR_BUS: {
                    sb.append("BIDIB_ERR_BUS for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), error number: ").append(ByteUtils.getInt(reasonData[0]));
                    break;
                }
                case BIDIB_ERR_ADDRSTACK: {
                    sb.append("BIDIB_ERR_ADDRSTACK for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), data: ").append(ByteUtils.toString(reasonData));
                    break;
                }
                case BIDIB_ERR_IDDOUBLE: {
                    sb.append("BIDIB_ERR_IDDOUBLE for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                    if (reasonData != null && reasonData.length > 6) {
                        sb.append(", uniqueId: ").append(ByteUtils.convertUniqueIdToString(reasonData));
                    }
                    break;
                }
                case BIDIB_ERR_SUBCRC: {
                    sb.append("BIDIB_ERR_SUBCRC for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType()));
                    if (nodeFinder != null) {
                        try {
                            sb.append("), error on node: ");
                            Node erroredNode = nodeFinder.apply(NodeUtils.combineAddress(addr, reasonData[0]));
                            if (erroredNode != null) {
                                String erroredNodeIdentifier = MessageUtils.formatNodeAddressAndName(erroredNode);
                                sb.append(erroredNodeIdentifier);
                                break;
                            }
                            sb.append(NodeUtils.formatAddressLong(NodeUtils.combineAddress(addr, reasonData[0])));
                            break;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Find the node by address failed: " + NodeUtils.formatAddressLong(addr, reasonData[0]));
                        }
                    }
                    sb.append("), error on node address: ").append(NodeUtils.formatAddressLong(addr, reasonData[0]));
                    break;
                }
                case BIDIB_ERR_SUBTIME: {
                    sb.append("BIDIB_ERR_SUBTIME for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", ByteUtils.getInt(sysErrorEnum.getType())));
                    if (nodeFinder != null) {
                        try {
                            sb.append("), error on node: ");
                            Node erroredNode = nodeFinder.apply(NodeUtils.combineAddress(addr, reasonData[0]));
                            if (erroredNode != null) {
                                String erroredNodeIdentifier = MessageUtils.formatNodeAddressAndName(erroredNode);
                                sb.append(erroredNodeIdentifier);
                                break;
                            }
                            sb.append(NodeUtils.formatAddressLong(NodeUtils.combineAddress(addr, reasonData[0])));
                            break;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Find the node by address failed: " + NodeUtils.formatAddressLong(addr, reasonData[0]));
                        }
                    }
                    sb.append("), error on node address: ").append(NodeUtils.formatAddressLong(addr, reasonData[0]));
                    break;
                }
                case BIDIB_ERR_SUBPAKET: {
                    sb.append("BIDIB_ERR_SUBPAKET for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType()));
                    if (nodeFinder != null) {
                        try {
                            sb.append("), error on node: ");
                            Node erroredNode = nodeFinder.apply(NodeUtils.combineAddress(addr, reasonData[0]));
                            if (erroredNode != null) {
                                String erroredNodeIdentifier = MessageUtils.formatNodeAddressAndName(erroredNode);
                                sb.append(erroredNodeIdentifier);
                                break;
                            }
                            sb.append(NodeUtils.formatAddressLong(NodeUtils.combineAddress(addr, reasonData[0])));
                            break;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Find the node by address failed: " + NodeUtils.formatAddressLong(addr, reasonData[0]));
                        }
                    }
                    sb.append("), error on node address: ").append(NodeUtils.formatAddressLong(addr, reasonData[0]));
                    break;
                }
                case BIDIB_ERR_OVERRUN: {
                    sb.append("BIDIB_ERR_OVERRUN for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                    break;
                }
                case BIDIB_ERR_HW: {
                    sb.append("BIDIB_ERR_HW for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append("), manufacturer specific error number: ").append(ByteUtils.getInt(reasonData[0]));
                    break;
                }
                case BIDIB_ERR_RESET_REQUIRED: {
                    sb.append("BIDIB_ERR_RESET_REQUIRED for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                    break;
                }
                case BIDIB_ERR_NO_SECACK_BY_HOST: {
                    sb.append("BIDIB_ERR_NO_SECACK_BY_HOST for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                    break;
                }
                default: {
                    sb.append("Unknown error for node: ").append(nodeIdentifier).append(", errorCode: ").append(sysErrorEnum.getType()).append(" (0x").append(String.format("%02x", sysErrorEnum.getType())).append(")");
                }
            }
        }
        catch (Exception ex) {
            sb.append("Format error message failed, sysErrorEnum: ");
            sb.append(sysErrorEnum).append(", Reason: ").append(ex.getMessage());
        }
    }
}

