/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;
import org.bidib.jbidibc.messages.utils.collections4.IterableUtils;
import org.bidib.jbidibc.messages.utils.collections4.Predicate;

public class NodeUtils {
    public static final int INTERFACE_ADDRESS = 0;
    public static final byte[] ROOT_ADDRESS = new byte[]{0};
    private static final long MASK_IGNORE_CLASSBITS = 0xFFFFFFFFFFL;

    public static boolean isAddressEqual(byte[] addr1, byte[] addr2) {
        return Arrays.equals(addr1, addr2);
    }

    public static int convertAddress(byte[] address) {
        int result = 0;
        if (address != null) {
            for (int index = 0; index < address.length; ++index) {
                result += address[index] << index * 8;
            }
        }
        return result;
    }

    public static String formatAddress(byte[] address) {
        if (address == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < address.length; ++index) {
            sb.append(Byte.toString(address[index]));
            if (index >= address.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static String formatAddresses(List<byte[]> addresses) {
        if (addresses == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte[] address : addresses) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int index = 0; index < address.length; ++index) {
                sb.append(Byte.toString(address[index]));
                if (index >= address.length - 1) continue;
                sb.append(".");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static String formatAddressLong(byte[] parentAddress, byte localAddress) {
        byte[] addr = NodeUtils.combineAddress(parentAddress, localAddress);
        return NodeUtils.formatAddressLong(addr);
    }

    public static byte[] combineAddress(byte[] parentAddress, byte localAddress) {
        byte[] addr = new byte[parentAddress.length + 1];
        if (parentAddress.length == 1 && parentAddress[0] == 0) {
            addr = new byte[]{localAddress};
        } else if (localAddress == 0) {
            addr = new byte[parentAddress.length];
            System.arraycopy(parentAddress, 0, addr, 0, parentAddress.length);
        } else {
            System.arraycopy(parentAddress, 0, addr, 0, parentAddress.length);
            addr[parentAddress.length] = localAddress;
        }
        return addr;
    }

    public static String formatAddressLong(byte[] address) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < 4; ++index) {
            if (index < address.length) {
                sb.append(Byte.toString(address[index]));
            } else {
                sb.append(Byte.toString((byte)0));
            }
            if (index >= 3) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static int getLocalAddress(byte[] address) {
        return ByteUtils.getInt(address[address.length - 1]);
    }

    public static int getClass(long uniqueId) {
        return (int)(uniqueId >> 48 & 0xFFL);
    }

    public static boolean hasAccessoryFunctions(long uniqueId) {
        return (uniqueId >> 48 & 4L) == 4L;
    }

    public static boolean hasBoosterFunctions(long uniqueId) {
        return (uniqueId >> 48 & 2L) == 2L;
    }

    public static boolean hasFeedbackFunctions(long uniqueId) {
        return (uniqueId >> 48 & 0x40L) == 64L;
    }

    public static long setHasFeedbackFunctions(long uniqueId) {
        long temp = 0x40000000000000L;
        return uniqueId |= temp;
    }

    public static boolean hasSubNodesFunctions(long uniqueId) {
        return (uniqueId >> 48 & 0x80L) == 128L;
    }

    public static long setHasSubNodesFunctions(long uniqueId) {
        return uniqueId | 0x80000000000000L;
    }

    public static boolean hasSwitchFunctions(long uniqueId) {
        return (uniqueId >> 48 & 1L) == 1L;
    }

    public static boolean hasCommandStationProgrammingFunctions(long uniqueId) {
        return (uniqueId >> 48 & 8L) == 8L;
    }

    public static boolean hasCommandStationFunctions(long uniqueId) {
        return (uniqueId >> 48 & 0x10L) == 16L;
    }

    public static boolean hasOperatingFunctions(long uniqueId) {
        return (uniqueId >> 48 & 0x20L) == 32L;
    }

    public static String[] getPidAndSerialNumberAsString(long uniqueId, int pidBits) {
        return new String[]{"PID: ???", "Serial: ???"};
    }

    public static byte[] getUniqueId(long uniqueId) {
        byte[] result = new byte[7];
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(uniqueId);
        System.arraycopy(bb.array(), 1, result, 0, result.length);
        return result;
    }

    public static long getUniqueId(byte[] uniqueId) {
        long result = 0L;
        for (int i = 0; i < uniqueId.length; ++i) {
            result = (result << 8) + (long)(uniqueId[i] & 0xFF);
        }
        return result;
    }

    public static boolean compareUniqueIdIgnoreClassbits(long left, long right) {
        return (left &= 0xFFFFFFFFFFL) == (right &= 0xFFFFFFFFFFL);
    }

    public static long getUniqueIdIgnoreClassbits(long uniqueId) {
        return uniqueId & 0xFFFFFFFFFFL;
    }

    public static Long getUniqueIdIgnoreClassbits(Long uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        return uniqueId & 0xFFFFFFFFFFL;
    }

    public static byte[] getTargetModeUniqueId(TargetModeEnum targetMode, long uniqueId) {
        if (targetMode != TargetModeEnum.BIDIB_TARGET_MODE_UID) {
            return null;
        }
        return NodeUtils.getTargetModeUniqueId(uniqueId);
    }

    public static byte[] getTargetModeUniqueId(long uniqueId) {
        byte[] result = new byte[5];
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(uniqueId);
        System.arraycopy(bb.array(), 3, result, 0, result.length);
        return result;
    }

    public static byte[] getTargetModeUniqueIdIgnoreClassbits(long uniqueId) {
        uniqueId = NodeUtils.getUniqueIdIgnoreClassbits(uniqueId);
        byte[] result = new byte[5];
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(uniqueId);
        System.arraycopy(bb.array(), 3, result, 0, result.length);
        return result;
    }

    public static int getVendorId(long uniqueId) {
        return (int)(uniqueId >> 32) & 0xFF;
    }

    public static int getPid(long uniqueId) {
        long pid = uniqueId >> 24 & 0xFFL | uniqueId >> 8 & 0xFF00L;
        return (int)pid;
    }

    public static int getPid(long uniqueId, int relevantPidBits) {
        long pidAndSerial = uniqueId >> 24 & 0xFFL | uniqueId >> 8 & 0xFF00L;
        long mask = (1 << relevantPidBits) - 1;
        long pid = pidAndSerial & mask;
        return (int)pid;
    }

    public static boolean isMatchingVidAndPid(long uniqueId, int vid, int pid) {
        return NodeUtils.getPid(uniqueId) == pid && NodeUtils.getVendorId(uniqueId) == vid;
    }

    public static boolean isMatchingVidAndPid(long uniqueId, int relevantPidBits, int vid, int pid) {
        return NodeUtils.getPid(uniqueId, relevantPidBits) == pid && NodeUtils.getVendorId(uniqueId) == vid;
    }

    public static Node findNodeByAddress(Iterable<Node> nodes, final byte[] address) {
        Node node = IterableUtils.find(nodes, new Predicate<Node>(){

            @Override
            public boolean evaluate(Node node) {
                return Arrays.equals(node.getAddr(), address);
            }
        });
        return node;
    }

    public static Node findNodeByUuid(Iterable<Node> nodes, final long uuid) {
        Node node = IterableUtils.find(nodes, new Predicate<Node>(){

            @Override
            public boolean evaluate(Node node) {
                return node.getUniqueId() == uuid;
            }
        });
        return node;
    }

    public static boolean isSubNode(Node parent, Node node) {
        byte[] parentAddress = parent.getAddr();
        byte[] nodeAddress = node.getAddr();
        return NodeUtils.isSubNode(parentAddress, nodeAddress);
    }

    public static boolean isSubNode(byte[] parentAddress, byte[] nodeAddress) {
        if (Arrays.equals(parentAddress, nodeAddress)) {
            return false;
        }
        if (parentAddress.length == 1 && parentAddress[0] == 0) {
            parentAddress = new byte[]{};
        }
        if (nodeAddress.length >= parentAddress.length + 1) {
            byte[] compareAddress = new byte[parentAddress.length];
            System.arraycopy(nodeAddress, 0, compareAddress, 0, parentAddress.length);
            if (Arrays.equals(parentAddress, compareAddress)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNodeOrSubNode(Node parent, Node node) {
        byte[] nodeAddress;
        byte[] parentAddress = parent.getAddr();
        if (Arrays.equals(parentAddress, nodeAddress = node.getAddr())) {
            return true;
        }
        if (parentAddress.length == 1 && parentAddress[0] == 0) {
            parentAddress = new byte[]{};
        }
        if (nodeAddress.length >= parentAddress.length + 1) {
            byte[] compareAddress = new byte[parentAddress.length];
            System.arraycopy(nodeAddress, 0, compareAddress, 0, parentAddress.length);
            if (Arrays.equals(parentAddress, compareAddress)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDirectSubNode(byte[] parentAddress, byte[] nodeAddress) {
        if (Arrays.equals(parentAddress, nodeAddress)) {
            return false;
        }
        if (parentAddress.length == 1 && parentAddress[0] == 0) {
            parentAddress = new byte[]{};
        }
        if (nodeAddress.length == parentAddress.length + 1) {
            byte[] compareAddress = new byte[parentAddress.length];
            System.arraycopy(nodeAddress, 0, compareAddress, 0, parentAddress.length);
            if (Arrays.equals(parentAddress, compareAddress)) {
                return true;
            }
        }
        return false;
    }

    public static String prepareNodeLabel(Node node) {
        Object nodeLabel = node.getStoredString(1);
        String productString = node.getStoredString(0);
        if (StringUtils.isBlank((CharSequence)nodeLabel)) {
            nodeLabel = ByteUtils.getUniqueIdAsString(node.getUniqueId());
        }
        if (StringUtils.isNotBlank(productString)) {
            nodeLabel = (String)nodeLabel + " (" + productString + ")";
        }
        return nodeLabel;
    }

    public static Feature getFeature(FeatureEnum featureKey, Iterable<Feature> features) {
        final int featureNumber = featureKey.getNumber();
        Feature feature = IterableUtils.find(features, new Predicate<Feature>(){

            @Override
            public boolean evaluate(Feature feature) {
                return feature.getType() == featureNumber;
            }
        });
        return feature;
    }
}

