/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.utils.collections4;

import java.util.Iterator;
import org.bidib.jbidibc.messages.utils.collections4.IteratorUtils;
import org.bidib.jbidibc.messages.utils.collections4.Predicate;
import org.bidib.jbidibc.messages.utils.collections4.ResettableIterator;
import org.bidib.jbidibc.messages.utils.collections4.iterators.EmptyIterator;

public class IterableUtils {
    public static <E> E find(Iterator<E> iterator, Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                E element = iterator.next();
                if (!predicate.evaluate(element)) continue;
                return element;
            }
        }
        return null;
    }

    public static <E> E find(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.find(IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    private static <E> Iterator<E> emptyIteratorIfNull(Iterable<E> iterable) {
        return iterable != null ? iterable.iterator() : IteratorUtils.emptyIterator();
    }

    public static <E> ResettableIterator<E> emptyIterator() {
        return EmptyIterator.resettableEmptyIterator();
    }
}

