/*
 * Decompiled with CFR 0.152.
 */
package sidlo64.translatorsHelper;

import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LanguageVersion
implements Comparable<LanguageVersion> {
    private int translated;
    private float percentTranslated;
    private Locale locale;
    private String suffix;
    private Icon icon;

    public LanguageVersion(String language) {
        this.locale = new Locale(language);
        this.suffix = "_" + language;
        this.setIcon();
    }

    public LanguageVersion(String language, String country) {
        this.locale = new Locale(language, country);
        this.suffix = "_" + language + "_" + country;
        this.setIcon();
    }

    public LanguageVersion(Locale locale) {
        this.locale = locale;
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        this.suffix = country.isEmpty() ? "_" + language : "_" + language + "_" + country;
        this.setIcon();
    }

    public int getTranslated() {
        return this.translated;
    }

    public void setTranslated(int translated) {
        this.translated = translated;
    }

    public float getPercentTranslated() {
        return this.percentTranslated;
    }

    public void setPercentTranslated(float percentTranslated) {
        this.percentTranslated = percentTranslated;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public int compareTo(LanguageVersion o) {
        return this.locale.getDisplayName().compareTo(o.locale.getDisplayName());
    }

    public String toString() {
        return this.locale.getDisplayName();
    }

    private void setIcon() {
        String iconPath;
        ClassLoader imageDir = this.getClass().getClassLoader();
        URL imageURL = imageDir.getResource(iconPath = "sidlo64/translatorsHelper/flag" + this.suffix + ".png");
        if (imageURL != null) {
            this.icon = new ImageIcon(imageURL);
        } else {
            iconPath = "sidlo64/translatorsHelper/flag.png";
            imageURL = imageDir.getResource(iconPath);
            this.icon = new ImageIcon(imageURL);
        }
    }
}

