/*
 * Decompiled with CFR 0.152.
 */
package sidlo64.translatorsHelper;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import sidlo64.translatorsHelper.CbmLanguage;
import sidlo64.translatorsHelper.ProgressRenderer;
import sidlo64.translatorsHelper.RecordFile;
import sidlo64.translatorsHelper.RendererInteger;

public class TableFile
extends AbstractTableModel {
    private static final int COLUMN_FILE = 0;
    private static final int COLUMN_NUMBER_OF_KEYS = 1;
    private static final int COLUMN_TRANSLATED = 2;
    private static final int COLUMN_PROGRESS = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String TITLE_FILE = "File";
    private static final String TITLE_NUMBER_OF_KEYS = "Keys";
    private static final String TITLE_TRANSLATED = "Translated";
    private static final String TITLE_PROGRESS = "Progress";
    private List<RecordFile> data = new ArrayList<RecordFile>();
    private int showLanguage;
    private final CbmLanguage cbmLanguage;

    public TableFile(CbmLanguage listOfLanguageVersions) {
        this.cbmLanguage = listOfLanguageVersions;
    }

    public void setShowLanguage(int showLanguage) {
        if (showLanguage > this.cbmLanguage.getSize()) {
            showLanguage = 0;
        }
        this.showLanguage = showLanguage;
        this.fireTableDataChanged();
    }

    public int getShowLanguage() {
        return this.showLanguage;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RecordFile oneRecord = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return oneRecord.getFileName();
            }
            case 1: {
                return oneRecord.getNumberOfKeys();
            }
            case 2: {
                return oneRecord.getListOfLanguageVersions().getElementAt(this.showLanguage).getTranslated();
            }
            case 3: {
                float floatNumber = oneRecord.getListOfLanguageVersions().getElementAt(this.showLanguage).getPercentTranslated();
                int integerNumber = Math.round(floatNumber);
                return integerNumber;
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Float.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return TITLE_FILE;
            }
            case 1: {
                return TITLE_NUMBER_OF_KEYS;
            }
            case 2: {
                return TITLE_TRANSLATED;
            }
            case 3: {
                return TITLE_PROGRESS;
            }
        }
        return null;
    }

    public void addRow(RecordFile recordFile) {
        boolean addRecord = true;
        for (RecordFile oneRecord : this.data) {
            if (!oneRecord.getFileName().equals(recordFile.getFileName())) continue;
            addRecord = false;
        }
        if (addRecord) {
            this.data.add(recordFile);
        }
    }

    public RecordFile getRow(int row) {
        return this.data.get(row);
    }

    public void setColumns(JTable table) {
        table.getColumnModel().getColumn(0).setPreferredWidth(500);
        table.getColumnModel().getColumn(1).setPreferredWidth(60);
        table.getColumnModel().getColumn(2).setPreferredWidth(60);
        table.getColumnModel().getColumn(3).setPreferredWidth(120);
        table.getColumnModel().getColumn(1).setCellRenderer(new RendererInteger());
        table.getColumnModel().getColumn(2).setCellRenderer(new RendererInteger());
        table.getColumnModel().getColumn(3).setCellRenderer(new ProgressRenderer(0, 100));
    }
}

